/*
 * Decompiled with CFR 0.152.
 */
package edu.northwestern.at.utils.math;

import edu.northwestern.at.utils.XCloneable;
import java.io.Serializable;

public class Probability
implements XCloneable,
Comparable,
Serializable {
    protected double logProbability;
    public static final Probability ZERO_PROBABILITY = new Probability(0.0);
    public static final Probability ONE_PROBABILITY = new Probability(1.0);

    public Probability() throws IllegalArgumentException {
        this.logProbability = Double.NEGATIVE_INFINITY;
    }

    public Probability(double probability) throws IllegalArgumentException {
        this.setProbability(probability);
    }

    public void setProbability(double probability) throws IllegalArgumentException {
        if (probability < 0.0 || probability > 1.0) {
            throw new IllegalArgumentException("Bad probability (" + probability + "), should be a number" + " from 0 through 1 inclusive.");
        }
        this.logProbability = probability == 0.0 ? Double.NEGATIVE_INFINITY : (probability == 1.0 ? 0.0 : Math.log(probability));
    }

    public void setLogProbability(double logProbability) throws IllegalArgumentException {
        if (logProbability > 0.0) {
            throw new IllegalArgumentException("logProbability should be a number from -infinity through 0 inclusive.");
        }
        this.logProbability = logProbability;
    }

    public double getProbability() {
        return Math.exp(this.logProbability);
    }

    public double getLogProbability() {
        return this.logProbability;
    }

    public Probability multiply(Probability otherProbability) {
        Probability result = new Probability();
        result.setLogProbability(this.logProbability + otherProbability.logProbability);
        return result;
    }

    public Probability multiply(Probability otherProbability1, Probability otherProbability2) {
        Probability result = new Probability();
        result.setLogProbability(this.logProbability + otherProbability1.logProbability + otherProbability2.logProbability);
        return result;
    }

    public Probability multiply(Probability otherProbability1, Probability otherProbability2, Probability otherProbability3) {
        Probability result = new Probability();
        result.setLogProbability(this.logProbability + otherProbability1.logProbability + otherProbability2.logProbability + otherProbability3.logProbability);
        return result;
    }

    public String toString() {
        return this.getProbability() + "";
    }

    @Override
    public Object clone() {
        return new Probability(this.logProbability);
    }

    public int compareTo(Object object) {
        return Double.compare(this.logProbability, ((Probability)object).logProbability);
    }

    public boolean equals(Object object) {
        return Double.compare(this.logProbability, ((Probability)object).logProbability) == 0;
    }

    public int hashCode() {
        long bits = Double.doubleToLongBits(this.logProbability);
        return (int)(bits ^ bits >>> 32);
    }
}

