/*
 * Decompiled with CFR 0.152.
 */
package edu.northwestern.at.utils.logger;

import edu.northwestern.at.utils.DebugUtils;
import edu.northwestern.at.utils.logger.Logger;
import edu.northwestern.at.utils.logger.LoggerUtils;
import java.io.BufferedOutputStream;
import java.io.OutputStream;
import java.io.PrintStream;

public class StandardErrorLogger
implements Logger {
    protected PrintStream printStream = null;
    protected boolean loggerEnabled = false;
    protected static final String[] errorLevelStrings = new String[]{"FATAL", "ERROR", "WARN ", "INFO ", "DEBUG"};
    protected Object lock = new Object();

    public StandardErrorLogger() {
        try {
            this.printStream = new PrintStream((OutputStream)new BufferedOutputStream(System.err), true, "utf-8");
            this.loggerEnabled = false;
        }
        catch (Exception e) {
            this.loggerEnabled = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void terminate() {
        Object object = this.lock;
        synchronized (object) {
            try {
                this.printStream.close();
                this.loggerEnabled = false;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    @Override
    public void logDebug(String str) {
        this.log(4, str);
    }

    @Override
    public void logInfo(String str) {
        this.log(3, str);
    }

    @Override
    public void logWarning(String str) {
        this.log(2, str);
    }

    @Override
    public void logError(String str) {
        this.log(1, str);
    }

    @Override
    public void logError(String str, Throwable t) {
        this.log(1, str, t);
    }

    @Override
    public void logFatal(String str) {
        this.log(0, str);
    }

    @Override
    public void logFatal(String str, Throwable t) {
        this.log(0, str, t);
    }

    protected static String getErrorLevelString(int level) {
        String result = "?    ";
        if (level >= 0 && level <= 4) {
            result = errorLevelStrings[level];
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void log(int level, String str) {
        Object object = this.lock;
        synchronized (object) {
            this.printStream.println(LoggerUtils.getFormattedCurrentDateAndTime() + " " + StandardErrorLogger.getErrorLevelString(level) + " - " + str);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void log(int level, String str, Throwable t) {
        String stackTrace = DebugUtils.getStackTrace(t);
        String[] stackTraceLines = stackTrace.split("\\n");
        Object object = this.lock;
        synchronized (object) {
            this.printStream.println(LoggerUtils.getFormattedCurrentDateAndTime() + " " + StandardErrorLogger.getErrorLevelString(level) + " - " + str);
            for (int i = 0; i < stackTraceLines.length; ++i) {
                this.printStream.println(LoggerUtils.getFormattedCurrentDateAndTime() + " " + "      - " + stackTraceLines[i]);
            }
        }
    }

    @Override
    public boolean isDebuggingEnabled() {
        return true;
    }

    @Override
    public boolean isLoggerEnabled() {
        return this.loggerEnabled;
    }
}

