/*
 * Decompiled with CFR 0.152.
 */
package edu.northwestern.at.utils.db.mysql;

import edu.northwestern.at.utils.Env;

public class MySQLInsertGenerator {
    protected String tableName;
    protected String[] fieldNames;
    protected boolean[] isNumeric;
    protected StringBuffer insertBuffer;

    public MySQLInsertGenerator(String tableName, String[] fieldNames, boolean[] isNumeric) {
        this.tableName = tableName;
        this.fieldNames = fieldNames;
        this.isNumeric = isNumeric;
        this.insertBuffer = new StringBuffer();
    }

    protected String escapeSingleQuotes(String value) {
        String result = value;
        if (result.indexOf("'") >= 0) {
            StringBuffer sb = new StringBuffer();
            for (int i = 0; i < result.length(); ++i) {
                char ch = result.charAt(i);
                if (ch == '\'') {
                    sb.append("\\'");
                    continue;
                }
                sb.append(ch);
            }
            result = sb.toString();
        }
        return result;
    }

    public void addRow(Object[] rowData) {
        int i;
        if (this.insertBuffer.length() == 0) {
            this.insertBuffer.append(Env.LINE_SEPARATOR);
            this.insertBuffer.append("insert into ");
            this.insertBuffer.append(this.tableName);
            this.insertBuffer.append("(");
            for (i = 0; i < this.fieldNames.length; ++i) {
                if (i > 0) {
                    this.insertBuffer.append(", ");
                }
                this.insertBuffer.append(this.fieldNames[i]);
            }
            this.insertBuffer.append(") values (");
        } else {
            this.insertBuffer.append(", (");
        }
        for (i = 0; i < Math.min(rowData.length, this.fieldNames.length); ++i) {
            if (i > 0) {
                this.insertBuffer.append(",");
            }
            if (rowData[i] == null) {
                this.insertBuffer.append("NULL");
                continue;
            }
            String rowValue = rowData[i].toString();
            if (!this.isNumeric[i]) {
                this.insertBuffer.append("'");
                rowValue = this.escapeSingleQuotes(rowValue);
            }
            this.insertBuffer.append(rowValue);
            if (this.isNumeric[i]) continue;
            this.insertBuffer.append("'");
        }
        for (i = rowData.length; i < this.fieldNames.length; ++i) {
            if (i > 0) {
                this.insertBuffer.append(",");
            }
            this.insertBuffer.append("NULL,");
        }
        this.insertBuffer.append(")");
        this.insertBuffer.append(Env.LINE_SEPARATOR);
    }

    public String getInsert() {
        String result = this.insertBuffer.toString();
        this.insertBuffer = new StringBuffer();
        return result;
    }
}

