/*
 * Decompiled with CFR 0.152.
 */
package edu.northwestern.at.utils.csv;

import edu.northwestern.at.utils.ListFactory;
import edu.northwestern.at.utils.UnicodeReader;
import edu.northwestern.at.utils.csv.CSVFile;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.List;

public class CSVFileReader
extends CSVFile {
    protected BufferedReader in;

    public CSVFileReader(String inputFileName, String encoding) throws IOException, FileNotFoundException {
        this.openInputFile(inputFileName, encoding);
    }

    public CSVFileReader(String inputFileName, String encoding, char separator) throws IOException, FileNotFoundException {
        super(separator);
        this.openInputFile(inputFileName, encoding);
    }

    public CSVFileReader(String inputFileName, String encoding, char separator, char qualifier) throws FileNotFoundException, IOException {
        super(separator, qualifier);
        this.openInputFile(inputFileName, encoding);
    }

    protected void openInputFile(String inputFileName, String encoding) throws IOException {
        UnicodeReader streamReader = null;
        streamReader = encoding == null || encoding.length() == 0 ? new UnicodeReader(new FileInputStream(new File(inputFileName))) : new UnicodeReader(new FileInputStream(new File(inputFileName)), encoding);
        this.in = new BufferedReader(streamReader);
    }

    public List<String> readFields() throws IOException {
        List<String> fields = ListFactory.createNewList();
        StringBuffer sb = new StringBuffer();
        String line = this.in.readLine();
        if (line == null) {
            return null;
        }
        if (line.length() == 0) {
            fields.add(line);
            return fields;
        }
        int i = 0;
        do {
            sb.setLength(0);
            if (i < line.length() && line.charAt(i) == this.qualifier && line.charAt(i) != '\u0000') {
                ++i;
                i = this.handleQuotedField(line, sb, i);
            } else {
                i = this.handlePlainField(line, sb, i);
            }
            fields.add(sb.toString());
        } while (++i < line.length());
        return fields;
    }

    public void close() throws IOException {
        this.in.close();
    }

    protected int handleQuotedField(String s, StringBuffer sb, int i) {
        int j;
        int len = s.length();
        for (j = i; j < len; ++j) {
            if (s.charAt(j) == this.qualifier && j + 1 < len) {
                if (s.charAt(j + 1) == this.qualifier) {
                    ++j;
                } else if (s.charAt(j + 1) == this.separator) {
                    ++j;
                    break;
                }
            } else if (s.charAt(j) == this.qualifier && j + 1 == len) break;
            sb.append(s.charAt(j));
        }
        return j;
    }

    protected int handlePlainField(String s, StringBuffer sb, int i) {
        int result;
        int j = s.indexOf(this.separator, i);
        if (j == -1) {
            sb.append(s.substring(i));
            result = s.length();
        } else {
            sb.append(s.substring(i, j));
            result = j;
        }
        return result;
    }
}

