/*
 * Decompiled with CFR 0.152.
 */
package edu.northwestern.at.utils.cache;

import edu.northwestern.at.utils.cache.Cache;
import edu.northwestern.at.utils.cache.SoftReferenceCache;

public class OldLRUCache<K, V>
implements Cache<K, V> {
    protected int maxEntries;
    protected SoftReferenceCache<K, Node> cache = new SoftReferenceCache();
    protected Node head;
    protected Node tail;

    public OldLRUCache(int maxEntries) {
        this.maxEntries = maxEntries;
        if (this.maxEntries < 2) {
            this.maxEntries = 2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clear() {
        this.cache.clear();
        OldLRUCache oldLRUCache = this;
        synchronized (oldLRUCache) {
            this.head = null;
            this.tail = null;
        }
    }

    @Override
    public boolean containsKey(K key) {
        return this.cache.containsKey(key);
    }

    public int getMaxSize() {
        return this.maxEntries;
    }

    @Override
    public V get(K key) {
        V result = null;
        Node node = this.cache.get(key);
        if (node != null) {
            this.removeNode(node);
            this.insertNode(node);
            result = node.value;
        }
        return result;
    }

    @Override
    public V put(K key, V value) {
        Node keyNode;
        V result = null;
        if (this.cache.containsKey(key) && (keyNode = this.cache.remove(key)) != null) {
            result = keyNode.value;
        }
        while (this.size() >= this.maxEntries && this.deleteLeastRecentlyUsed()) {
        }
        Node node = new Node(key, value);
        this.cache.put(key, node);
        this.insertNode(node);
        return result;
    }

    @Override
    public V remove(K key) {
        V result = null;
        Node node = this.cache.get(key);
        if (node != null) {
            this.removeNode(node);
        }
        this.cache.remove(key);
        return result;
    }

    @Override
    public int size() {
        return this.cache.size();
    }

    protected synchronized boolean deleteLeastRecentlyUsed() {
        boolean result = false;
        if (this.tail != null) {
            this.cache.remove(this.tail.key);
            this.removeNode(this.tail);
            result = true;
        }
        return result;
    }

    protected synchronized void insertNode(Node node) {
        node.next = this.head;
        node.previous = null;
        if (this.head != null) {
            this.head.previous = node;
        }
        this.head = node;
        if (this.tail == null) {
            this.tail = node;
        }
    }

    protected synchronized void removeNode(Node node) {
        if (node.previous != null) {
            node.previous.next = node.next;
        } else {
            this.head = node.next;
        }
        if (node.next != null) {
            node.next.previous = node.previous;
        } else {
            this.tail = node.previous;
        }
    }

    protected class Node {
        K key;
        V value;
        Node previous;
        Node next;

        protected Node(K key, V value) {
            this.key = key;
            this.value = value;
            this.previous = null;
            this.next = null;
        }
    }
}

