/*
 * Decompiled with CFR 0.152.
 */
package edu.northwestern.at.utils;

import edu.northwestern.at.utils.SetFactory;
import edu.northwestern.at.utils.TaggedStrings;
import edu.northwestern.at.utils.UnicodeReader;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Serializable;
import java.util.Calendar;
import java.util.Enumeration;
import java.util.Properties;
import java.util.Set;

public class UTF8Properties
extends Properties
implements TaggedStrings,
Serializable {
    protected static final String keyValueSeparators = "=: \t\r\n\f";

    public UTF8Properties() {
        this((Properties)null);
    }

    public UTF8Properties(Properties defaults) {
        this.defaults = defaults;
    }

    public synchronized void load(InputStream inputStream, String defaultValue) throws IOException {
        BufferedReader in = new BufferedReader(new UnicodeReader(inputStream, "utf-8"));
        String line = in.readLine();
        while (line != null) {
            if (!(line = UTF8Properties.removeLeadingWhiteSpace(line)).equals("") && line.charAt(0) != '#') {
                String property = line;
                while (this.isContinued(line)) {
                    property = property.substring(0, property.length() - 1);
                    line = in.readLine();
                    property = property + line;
                }
                if (!property.equals("")) {
                    int endOfKey;
                    for (endOfKey = 0; endOfKey < property.length() && keyValueSeparators.indexOf(property.charAt(endOfKey)) == -1; ++endOfKey) {
                    }
                    String key = property.substring(0, endOfKey);
                    String value = defaultValue;
                    if (endOfKey + 1 <= property.length()) {
                        value = property.substring(endOfKey + 1, property.length());
                    }
                    key = UTF8Properties.convertInputString(key);
                    value = UTF8Properties.convertInputString(UTF8Properties.removeLeadingWhiteSpace(value));
                    this.put(key, value);
                }
            }
            line = in.readLine();
        }
    }

    @Override
    public synchronized void load(InputStream inputStream) throws IOException {
        this.load(inputStream, null);
    }

    public static String removeLeadingWhiteSpace(String line) {
        int index;
        for (index = 0; index < line.length() && keyValueSeparators.indexOf(line.charAt(index)) != -1; ++index) {
        }
        return line.substring(index, line.length());
    }

    public static String convertInputString(String line) {
        StringBuffer sb = new StringBuffer(line.length());
        for (int index = 0; index < line.length(); ++index) {
            int currentChar = line.charAt(index);
            if (currentChar == 92) {
                currentChar = line.charAt(++index);
                switch (currentChar) {
                    case 102: {
                        currentChar = 12;
                        break;
                    }
                    case 110: {
                        currentChar = 10;
                        break;
                    }
                    case 114: {
                        currentChar = 13;
                        break;
                    }
                    case 116: {
                        currentChar = 9;
                        break;
                    }
                    case 117: {
                        ++index;
                        int unicodeValue = 0;
                        for (int i = 0; i < 4; ++i) {
                            if ((currentChar = (int)Character.toLowerCase(line.charAt(index++))) >= 48 && currentChar <= 57) {
                                unicodeValue = (unicodeValue << 4) + currentChar - 48;
                                continue;
                            }
                            if (currentChar >= 97 && currentChar <= 102) {
                                unicodeValue = (unicodeValue << 4) + 10 + currentChar - 97;
                                continue;
                            }
                            throw new IllegalArgumentException("Invalid \\uxxxx encoding.");
                        }
                        currentChar = (char)unicodeValue;
                        --index;
                        break;
                    }
                }
            }
            sb.append((char)currentChar);
        }
        return sb.toString();
    }

    protected String formatStringForOutput(String line) {
        int length = line.length();
        StringBuffer outBuffer = new StringBuffer(length * 2);
        block7: for (int i = 0; i < length; ++i) {
            char currentChar = line.charAt(i);
            switch (currentChar) {
                case '\\': {
                    outBuffer.append('\\');
                    outBuffer.append('\\');
                    continue block7;
                }
                case '\f': {
                    outBuffer.append('\\');
                    outBuffer.append('f');
                    continue block7;
                }
                case '\n': {
                    outBuffer.append('\\');
                    outBuffer.append('n');
                    continue block7;
                }
                case '\r': {
                    outBuffer.append('\\');
                    outBuffer.append('r');
                    continue block7;
                }
                case '\t': {
                    outBuffer.append('\\');
                    outBuffer.append('t');
                    continue block7;
                }
                default: {
                    outBuffer.append(currentChar);
                }
            }
        }
        return outBuffer.toString();
    }

    protected boolean isContinued(String line) {
        if (line != null && !line.equals("")) {
            return line.charAt(line.length() - 1) == '\\';
        }
        return false;
    }

    @Override
    public void save(OutputStream outputStream, String header) {
        try {
            this.store(outputStream, header);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void store(OutputStream outputStream, String header, boolean outputOnlyKeys) throws IOException {
        BufferedWriter output = new BufferedWriter(new OutputStreamWriter(outputStream, "utf-8"));
        UTF8Properties uTF8Properties = this;
        synchronized (uTF8Properties) {
            if (header != null) {
                output.write("#" + header);
                output.newLine();
            }
            output.write("#" + Calendar.getInstance().getTime());
            output.newLine();
            Enumeration<Object> enumeration = this.keys();
            while (enumeration.hasMoreElements()) {
                String key = this.formatStringForOutput((String)enumeration.nextElement());
                output.write(key);
                if (!outputOnlyKeys) {
                    String value = this.formatStringForOutput((String)this.get(key));
                    output.write("=" + value);
                }
                output.newLine();
            }
        }
        output.flush();
    }

    @Override
    public void store(OutputStream outputStream, String header) throws IOException {
        this.store(outputStream, header, false);
    }

    @Override
    public boolean containsString(String string) {
        return this.getProperty(string) != null;
    }

    @Override
    public String getTag(String string) {
        return this.getProperty(string);
    }

    @Override
    public void putTag(String string, String tag) {
        this.setProperty(string, tag);
    }

    @Override
    public int getStringCount() {
        return this.size();
    }

    @Override
    public Set<String> getAllStrings() {
        Set<String> result = SetFactory.createNewSet();
        Enumeration<?> enumeration = this.propertyNames();
        while (enumeration.hasMoreElements()) {
            result.add(enumeration.nextElement().toString());
        }
        return result;
    }

    @Override
    public Set<String> getAllTags() {
        Set<String> result = SetFactory.createNewSet();
        Enumeration<?> enumeration = this.propertyNames();
        while (enumeration.hasMoreElements()) {
            String key = (String)enumeration.nextElement();
            result.add(this.getProperty(key));
        }
        return result;
    }
}

