/*
 * Decompiled with CFR 0.152.
 */
package edu.northwestern.at.utils;

import edu.northwestern.at.utils.Env;
import edu.northwestern.at.utils.ListFactory;
import edu.northwestern.at.utils.UnicodeReader;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.List;

public class TextFile {
    protected File textFile = null;
    protected String textFileEncoding = "utf-8";
    protected String[] textFileLines = null;
    protected boolean textFileLoaded = false;

    public TextFile(File textFile, String encoding) {
        this.textFile = textFile;
        String safeEncoding = encoding == null ? "" : encoding;
        safeEncoding = safeEncoding.trim();
        if (safeEncoding.length() > 0) {
            this.textFileEncoding = safeEncoding;
        }
        this.openFile(textFile);
    }

    public TextFile(String textFileName, String encoding) {
        this(new File(textFileName), encoding);
    }

    public TextFile(String textFileName) {
        this(textFileName, null);
    }

    public TextFile(File textFile) {
        this(textFile, null);
    }

    public TextFile(InputStream inputStream, String encoding) {
        this.textFile = null;
        String safeEncoding = encoding == null ? "" : encoding;
        safeEncoding = safeEncoding.trim();
        if (safeEncoding.length() > 0) {
            this.textFileEncoding = safeEncoding;
        }
        this.openInputStream(inputStream);
    }

    public TextFile(URL url, String encoding) {
        this.textFile = null;
        String safeEncoding = encoding == null ? "" : encoding;
        safeEncoding = safeEncoding.trim();
        if (safeEncoding.length() > 0) {
            this.textFileEncoding = safeEncoding;
        }
        try {
            this.openInputStream(url.openStream());
        }
        catch (Exception e) {
            // empty catch block
        }
    }

    public TextFile(InputStream inputStream) {
        this(inputStream, null);
    }

    protected void openFile(File inputFile) {
        try {
            this.openInputStream(new FileInputStream(inputFile));
            this.textFileLoaded = true;
        }
        catch (FileNotFoundException fileNotFoundException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void openInputStream(InputStream inputStream) {
        List<String> lines = ListFactory.createNewList();
        BufferedReader bufferedReader = null;
        try {
            String textLine;
            bufferedReader = new BufferedReader(new UnicodeReader(inputStream, this.textFileEncoding));
            while ((textLine = bufferedReader.readLine()) != null) {
                lines.add(textLine);
            }
            this.textFileLoaded = true;
        }
        catch (IOException e) {
        }
        finally {
            try {
                if (bufferedReader != null) {
                    bufferedReader.close();
                }
            }
            catch (Exception e) {}
        }
        this.textFileLines = new String[lines.size()];
        for (int i = 0; i < lines.size(); ++i) {
            this.textFileLines[i] = (String)lines.get(i);
        }
    }

    public int size() {
        return this.textFileLines.length;
    }

    public boolean textLoaded() {
        return this.textFileLoaded;
    }

    public String[] toArray() {
        return this.textFileLines;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer(32768);
        for (int i = 0; i < this.textFileLines.length; ++i) {
            sb.append(this.textFileLines[i]);
            sb.append(Env.LINE_SEPARATOR);
        }
        return sb.toString();
    }
}

