/*
 * Decompiled with CFR 0.152.
 */
package edu.northwestern.at.utils;

import edu.northwestern.at.utils.ListFactory;
import edu.northwestern.at.utils.SetFactory;
import edu.northwestern.at.utils.StringUtils;
import edu.northwestern.at.utils.TaggedStrings;
import edu.northwestern.at.utils.TernaryTrieNode;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class TernaryTrie
implements TaggedStrings {
    protected TernaryTrieNode root;
    protected int nodeCount = 0;
    protected int maxKeyLength = 0;

    public TernaryTrie() {
    }

    public TernaryTrie(Map<String, String> stringsMap, boolean addValuesAsKeys) {
        for (String s : stringsMap.keySet()) {
            String s2 = stringsMap.get(s);
            this.put(s, s2);
            if (!addValuesAsKeys) continue;
            this.put(s2, s2);
        }
    }

    public TernaryTrie(Set<String> stringsSet) {
        for (String s : stringsSet) {
            this.put(s, s);
        }
    }

    public TernaryTrie(List<String> stringsList) {
        for (String s : stringsList) {
            this.put(s, s);
        }
    }

    public TernaryTrie(TaggedStrings stringsList, boolean addValuesAsKeys) {
        for (String s : stringsList.getAllStrings()) {
            String s2 = stringsList.getTag(s);
            this.put(s, s2);
            if (!addValuesAsKeys) continue;
            this.put(s2, s2);
        }
    }

    public void addCollection(Collection<String> collection) {
        for (String s : collection) {
            this.put(s, s);
        }
    }

    public Object put(String word, Object value) {
        Object result = null;
        if (word != null) {
            TernaryTrieNode wordNode = this.findNode(this.root, word, 0);
            if (wordNode != null) {
                result = wordNode.getValue();
                wordNode.setValue(value);
            } else {
                this.root = this.insertNode(this.root, word, 0, value);
            }
        }
        return result;
    }

    public Object get(String word) {
        TernaryTrieNode wordNode;
        Object result = null;
        if (word != null && (wordNode = this.findNode(this.root, word, 0)) != null) {
            result = wordNode.getValue();
        }
        return result;
    }

    public boolean containsKey(String word) {
        return this.searchNode(this.root, word, 0);
    }

    public List<String> partialSearch(String word) {
        List<String> list = ListFactory.createNewList();
        return this.partialSearchNode(this.root, list, "", word, 0);
    }

    public List<String> prefixSearch(String prefix) {
        List<String> matches = null;
        if (prefix != null) {
            String prefixPattern = prefix + StringUtils.dupl(".", this.maxKeyLength - prefix.length());
            List<String> list = ListFactory.createNewList();
            matches = this.prefixSearchNode(this.root, list, "", prefix, prefixPattern, 0);
        }
        return matches;
    }

    protected List<String> prefixSearchNode(TernaryTrieNode node, List<String> matches, String match, String prefix, String prefixPattern, int index) {
        if (node != null && index < prefixPattern.length()) {
            char c = prefixPattern.charAt(index);
            char split = node.getSplitChar();
            if (c == '.' || c < split) {
                matches = this.prefixSearchNode(node.getLokid(), matches, match, prefix, prefixPattern, index);
            }
            if (c == '.' || c == split) {
                String partialWord = match + split;
                if (node.isEndOfWord() && partialWord.startsWith(prefix)) {
                    matches.add(partialWord);
                }
                matches = this.prefixSearchNode(node.getEqkid(), matches, partialWord, prefix, prefixPattern, index + 1);
            }
            if (c == '.' || c > split) {
                matches = this.prefixSearchNode(node.getHikid(), matches, match, prefix, prefixPattern, index);
            }
        }
        return matches;
    }

    public List<String> nearSearch(String word, int distance) {
        List<String> list = ListFactory.createNewList();
        return this.nearSearchNode(this.root, distance, list, "", word, 0);
    }

    public List<String> getWords() {
        List<String> list = ListFactory.createNewList();
        return this.traverseNode(this.root, "", list);
    }

    protected TernaryTrieNode insertNode(TernaryTrieNode node, String word, int index, Object value) {
        if (index < word.length()) {
            char split;
            char c = word.charAt(index);
            if (node == null) {
                node = new TernaryTrieNode(c);
            }
            if (c < (split = node.getSplitChar())) {
                node.setLokid(this.insertNode(node.getLokid(), word, index, value));
            } else if (c == split) {
                if (index == word.length() - 1) {
                    node.setEndOfWord(true);
                    node.setValue(value);
                    ++this.nodeCount;
                    this.maxKeyLength = Math.max(this.maxKeyLength, word.length());
                }
                node.setEqkid(this.insertNode(node.getEqkid(), word, index + 1, value));
            } else {
                node.setHikid(this.insertNode(node.getHikid(), word, index, value));
            }
        }
        return node;
    }

    protected boolean searchNode(TernaryTrieNode node, String word, int index) {
        boolean success = false;
        if (node != null && index < word.length()) {
            char split;
            char c = word.charAt(index);
            if (c < (split = node.getSplitChar())) {
                return this.searchNode(node.getLokid(), word, index);
            }
            if (c > split) {
                return this.searchNode(node.getHikid(), word, index);
            }
            if (index == word.length() - 1) {
                if (node.isEndOfWord()) {
                    success = true;
                }
            } else {
                return this.searchNode(node.getEqkid(), word, index + 1);
            }
        }
        return success;
    }

    protected TernaryTrieNode findNode(TernaryTrieNode node, String word, int index) {
        if (node != null && index < word.length()) {
            char split;
            char c = word.charAt(index);
            if (c < (split = node.getSplitChar())) {
                return this.findNode(node.getLokid(), word, index);
            }
            if (c > split) {
                return this.findNode(node.getHikid(), word, index);
            }
            if (index == word.length() - 1) {
                if (node.isEndOfWord()) {
                    return node;
                }
            } else {
                return this.findNode(node.getEqkid(), word, index + 1);
            }
        }
        return null;
    }

    protected List<String> partialSearchNode(TernaryTrieNode node, List<String> matches, String match, String word, int index) {
        if (node != null && index < word.length()) {
            char c = word.charAt(index);
            char split = node.getSplitChar();
            if (c == '.' || c < split) {
                matches = this.partialSearchNode(node.getLokid(), matches, match, word, index);
            }
            if (c == '.' || c == split) {
                if (index == word.length() - 1) {
                    if (node.isEndOfWord()) {
                        matches.add(match + split);
                    }
                } else {
                    matches = this.partialSearchNode(node.getEqkid(), matches, match + split, word, index + 1);
                }
            }
            if (c == '.' || c > split) {
                matches = this.partialSearchNode(node.getHikid(), matches, match, word, index);
            }
        }
        return matches;
    }

    protected List<String> nearSearchNode(TernaryTrieNode node, int distance, List<String> matches, String match, String word, int index) {
        if (node != null && distance >= 0) {
            char c = index < word.length() ? (char)word.charAt(index) : (char)'\uffff';
            char split = node.getSplitChar();
            if (distance > 0 || c < split) {
                matches = this.nearSearchNode(node.getLokid(), distance, matches, match, word, index);
            }
            String newMatch = match + split;
            if (c == split) {
                if (node.isEndOfWord() && distance >= 0 && newMatch.length() + distance >= word.length()) {
                    matches.add(newMatch);
                }
                matches = this.nearSearchNode(node.getEqkid(), distance, matches, newMatch, word, index + 1);
            } else {
                if (node.isEndOfWord() && distance - 1 >= 0 && newMatch.length() + (distance - 1) >= word.length()) {
                    matches.add(newMatch);
                }
                matches = this.nearSearchNode(node.getEqkid(), distance - 1, matches, newMatch, word, index + 1);
            }
            if (distance > 0 || c > split) {
                matches = this.nearSearchNode(node.getHikid(), distance, matches, match, word, index);
            }
        }
        return matches;
    }

    protected List<String> traverseNode(TernaryTrieNode node, String s, List<String> words) {
        if (node != null) {
            words = this.traverseNode(node.getLokid(), s, words);
            String c = String.valueOf(node.getSplitChar());
            if (node.getEqkid() != null) {
                if (node.endOfWord) {
                    words.add(s + c);
                }
                words = this.traverseNode(node.getEqkid(), s + c, words);
            } else {
                words.add(s + c);
            }
            words = this.traverseNode(node.getHikid(), s, words);
        }
        return words;
    }

    public int size() {
        return this.nodeCount;
    }

    @Override
    public boolean containsString(String string) {
        return this.containsKey(string);
    }

    @Override
    public String getTag(String string) {
        String result = null;
        Object value = this.get(string);
        if (value != null) {
            result = value.toString();
        }
        return result;
    }

    @Override
    public void putTag(String string, String tag) {
        this.put(string, tag);
    }

    @Override
    public int getStringCount() {
        return this.nodeCount;
    }

    @Override
    public Set<String> getAllStrings() {
        Set<String> result = SetFactory.createNewSet();
        List<String> list = ListFactory.createNewList();
        result.addAll(this.traverseNode(this.root, "", list));
        return result;
    }

    @Override
    public Set<String> getAllTags() {
        Set<String> result = SetFactory.createNewSet();
        List<String> list = ListFactory.createNewList();
        List<String> stringsList = this.traverseNode(this.root, "", list);
        for (String key : stringsList) {
            result.add(this.get(key).toString());
        }
        return result;
    }
}

