/*
 * Decompiled with CFR 0.152.
 */
package edu.northwestern.at.utils;

import edu.northwestern.at.utils.XCloneable;
import java.io.Serializable;
import java.util.Enumeration;

public class SparseBitSet
implements XCloneable,
Serializable {
    protected int[] offs;
    protected long[] bits;
    protected int size;
    protected static final int LG_BITS = 6;
    protected static final int BITS = 64;
    protected static final int BITS_M1 = 63;
    protected static final BinOp AND = new BinOp(){

        @Override
        public final long op(long a, long b) {
            return a & b;
        }
    };
    protected static final BinOp OR = new BinOp(){

        @Override
        public final long op(long a, long b) {
            return a | b;
        }
    };
    protected static final BinOp XOR = new BinOp(){

        @Override
        public final long op(long a, long b) {
            return a ^ b;
        }
    };
    protected static final BinOp ANDNOT = new BinOp(){

        @Override
        public final long op(long a, long b) {
            return a & (b ^ 0xFFFFFFFFFFFFFFFFL);
        }
    };

    public SparseBitSet() {
        this.bits = new long[4];
        this.offs = new int[4];
        this.size = 0;
    }

    public SparseBitSet(int nbits) {
        this();
    }

    public SparseBitSet(SparseBitSet set) {
        this.bits = new long[set.size];
        this.offs = new int[set.size];
        this.size = 0;
    }

    protected void new_block(int bnum) {
        this.new_block(this.bsearch(bnum), bnum);
    }

    protected void new_block(int idx, int bnum) {
        if (this.size == this.bits.length) {
            long[] nbits = new long[this.size * 3];
            int[] noffs = new int[this.size * 3];
            System.arraycopy(this.bits, 0, nbits, 0, this.size);
            System.arraycopy(this.offs, 0, noffs, 0, this.size);
            this.bits = nbits;
            this.offs = noffs;
        }
        this.insert_block(idx, bnum);
    }

    protected void insert_block(int idx, int bnum) {
        System.arraycopy(this.bits, idx, this.bits, idx + 1, this.size - idx);
        System.arraycopy(this.offs, idx, this.offs, idx + 1, this.size - idx);
        this.offs[idx] = bnum;
        this.bits[idx] = 0L;
        ++this.size;
    }

    protected int bsearch(int bnum) {
        int l = 0;
        int r = this.size;
        while (l < r) {
            int p = (l + r) / 2;
            if (bnum < this.offs[p]) {
                r = p;
                continue;
            }
            if (bnum > this.offs[p]) {
                l = p + 1;
                continue;
            }
            return p;
        }
        return l;
    }

    public void set(int bit) {
        int bnum = bit >> 6;
        int idx = this.bsearch(bnum);
        if (idx >= this.size || this.offs[idx] != bnum) {
            this.new_block(idx, bnum);
        }
        int n = idx;
        this.bits[n] = this.bits[n] | 1L << (bit & 0x3F);
    }

    public void clear(int bit) {
        int bnum = bit >> 6;
        int idx = this.bsearch(bnum);
        if (idx >= this.size || this.offs[idx] != bnum) {
            this.new_block(idx, bnum);
        }
        int n = idx;
        this.bits[n] = this.bits[n] & (1L << (bit & 0x3F) ^ 0xFFFFFFFFFFFFFFFFL);
    }

    public void clear() {
        this.size = 0;
    }

    public void clear(int fromIndex, int toIndex) {
        for (int bit = fromIndex; bit < toIndex; ++bit) {
            this.clear(bit);
        }
    }

    public void flip(int bit) {
        if (this.get(bit)) {
            this.clear(bit);
        } else {
            this.set(bit);
        }
    }

    public void flip(int fromIndex, int toIndex) {
        for (int bit = fromIndex; bit < toIndex; ++bit) {
            this.flip(bit);
        }
    }

    public boolean get(int bit) {
        int bnum = bit >> 6;
        int idx = this.bsearch(bnum);
        if (idx >= this.size || this.offs[idx] != bnum) {
            return false;
        }
        return 0L != (this.bits[idx] & 1L << (bit & 0x3F));
    }

    public void and(SparseBitSet otherSet) {
        SparseBitSet.binop(this, otherSet, AND);
    }

    public void or(SparseBitSet otherSet) {
        SparseBitSet.binop(this, otherSet, OR);
    }

    public void xor(SparseBitSet otherSet) {
        SparseBitSet.binop(this, otherSet, XOR);
    }

    public void andNot(SparseBitSet otherSet) {
        SparseBitSet.binop(this, otherSet, ANDNOT);
    }

    protected static final void binop(SparseBitSet a, SparseBitSet b, BinOp op) {
        int a_size;
        int a_zero;
        int[] noffs;
        long[] nbits;
        int nsize = a.size + b.size;
        if (a.bits.length < nsize) {
            nbits = new long[nsize];
            noffs = new int[nsize];
            a_zero = 0;
            a_size = a.size;
        } else {
            nbits = a.bits;
            noffs = a.offs;
            a_zero = a.bits.length - a.size;
            a_size = a.bits.length;
            System.arraycopy(a.bits, 0, a.bits, a_zero, a.size);
            System.arraycopy(a.offs, 0, a.offs, a_zero, a.size);
        }
        nsize = 0;
        int i = a_zero;
        int j = 0;
        while (i < a_size || j < b.size) {
            int no;
            long nb;
            if (i < a_size && (j >= b.size || a.offs[i] < b.offs[j])) {
                nb = op.op(a.bits[i], 0L);
                no = a.offs[i];
                ++i;
            } else if (j < b.size && (i >= a_size || a.offs[i] > b.offs[j])) {
                nb = op.op(0L, b.bits[j]);
                no = b.offs[j];
                ++j;
            } else {
                nb = op.op(a.bits[i], b.bits[j]);
                no = a.offs[i];
                ++i;
                ++j;
            }
            if (nb == 0L) continue;
            nbits[nsize] = nb;
            noffs[nsize] = no;
            ++nsize;
        }
        a.bits = nbits;
        a.offs = noffs;
        a.size = nsize;
    }

    public int hashCode() {
        long hash = 1234L;
        for (int i = 0; i < this.size; ++i) {
            hash ^= this.bits[i] * (long)this.offs[i];
        }
        return (int)(hash >> 32 ^ hash);
    }

    public int size() {
        return this.size == 0 ? 0 : 1 + this.offs[this.size - 1] << 6;
    }

    public boolean equals(Object object) {
        boolean result = false;
        if (object != null && object instanceof SparseBitSet) {
            result = SparseBitSet.equals(this, (SparseBitSet)object);
        }
        return result;
    }

    public static boolean equals(SparseBitSet a, SparseBitSet b) {
        int i = 0;
        int j = 0;
        while (i < a.size || j < b.size) {
            if (!(i < a.size && (j >= b.size || a.offs[i] < b.offs[j]) ? a.bits[i++] != 0L : (j < b.size && (i >= a.size || a.offs[i] > b.offs[j]) ? b.bits[j++] != 0L : a.bits[i++] != b.bits[j++]))) continue;
            return false;
        }
        return true;
    }

    public int cardinality() {
        int result = 0;
        Enumeration enumeration = this.elements();
        while (enumeration.hasMoreElements()) {
            enumeration.nextElement();
            ++result;
        }
        return result;
    }

    public boolean intersects(SparseBitSet otherSet) {
        boolean result = false;
        for (int i = Math.min(this.size, otherSet.size); i > 0 && !result; --i) {
            result = (this.bits[i] & otherSet.bits[i]) != 0L;
        }
        return result;
    }

    public int length() {
        int result;
        for (result = this.size(); !this.get(result) && result >= 0; --result) {
        }
        return result + 1;
    }

    public int nextSetBit(int fromIndex) {
        if (fromIndex < 0) {
            throw new IndexOutOfBoundsException("Index is negative");
        }
        int result = -1;
        int l = this.length();
        for (int i = fromIndex + 1; i < l; ++i) {
            if (!this.get(i)) continue;
            return i;
        }
        return -1;
    }

    public int nextClearBit(int fromIndex) {
        if (fromIndex < 0) {
            throw new IndexOutOfBoundsException("Index is negative");
        }
        int result = -1;
        int l = this.length();
        for (int i = fromIndex + 1; i < l; ++i) {
            if (this.get(i)) continue;
            return i;
        }
        return -1;
    }

    @Override
    public Object clone() {
        SparseBitSet set = new SparseBitSet();
        set.bits = (long[])this.bits.clone();
        set.offs = (int[])this.offs.clone();
        set.size = this.size;
        return set;
    }

    public Enumeration elements() {
        return new Enumeration(){
            int idx = -1;
            int bit = 64;
            {
                this.advance();
            }

            @Override
            public boolean hasMoreElements() {
                return this.idx < SparseBitSet.this.size;
            }

            public Object nextElement() {
                int r = this.bit + (SparseBitSet.this.offs[this.idx] << 6);
                this.advance();
                return new Integer(r);
            }

            protected void advance() {
                while (this.idx < SparseBitSet.this.size) {
                    while (++this.bit < 64) {
                        if (0L == (SparseBitSet.this.bits[this.idx] & 1L << this.bit)) continue;
                        return;
                    }
                    ++this.idx;
                    this.bit = -1;
                }
            }
        };
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append('{');
        Enumeration e = this.elements();
        while (e.hasMoreElements()) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append(e.nextElement());
        }
        sb.append('}');
        return sb.toString();
    }

    protected boolean isValid() {
        if (this.bits.length != this.offs.length) {
            return false;
        }
        if (this.size > this.bits.length) {
            return false;
        }
        if (this.size != 0 && 0 <= this.offs[0]) {
            return false;
        }
        for (int i = 1; i < this.size; ++i) {
            if (this.offs[i] >= this.offs[i - 1]) continue;
            return false;
        }
        return true;
    }

    protected static interface BinOp {
        public long op(long var1, long var3);
    }
}

