/*
 * Decompiled with CFR 0.152.
 */
package edu.northwestern.at.utils;

import edu.northwestern.at.utils.SetFactory;
import edu.northwestern.at.utils.TaggedStrings;
import java.util.Arrays;
import java.util.Set;

public class SingleTagTaggedStrings
implements TaggedStrings {
    protected String[] strings = null;
    protected String tag = null;

    public SingleTagTaggedStrings(String[] strings, String tag) {
        this.strings = strings;
        this.tag = tag;
        if (strings != null) {
            Arrays.sort(strings);
        }
    }

    @Override
    public boolean containsString(String string) {
        boolean result = false;
        if (this.strings != null) {
            result = Arrays.binarySearch(this.strings, string) >= 0;
        }
        return result;
    }

    @Override
    public String getTag(String string) {
        String result = null;
        int index = Arrays.binarySearch(this.strings, string);
        if (index >= 0) {
            result = this.tag;
        }
        return result;
    }

    @Override
    public int getStringCount() {
        int result = 0;
        if (this.strings != null) {
            result = this.strings.length;
        }
        return result;
    }

    @Override
    public Set<String> getAllStrings() {
        Set<String> result = SetFactory.createNewSet();
        result.addAll(Arrays.asList(this.strings));
        return result;
    }

    @Override
    public Set<String> getAllTags() {
        Set<String> result = SetFactory.createNewSet();
        if (this.tag != null) {
            result.add(this.tag);
        }
        return result;
    }

    @Override
    public void putTag(String string, String tag) {
    }
}

