/*
 * Decompiled with CFR 0.152.
 */
package edu.northwestern.at.utils;

import edu.northwestern.at.utils.MapFactory;
import java.util.Map;

public class RomanNumeralUtils {
    protected static final int MAX_ROMAN_NUMERAL = 5000;
    protected static String romanNumeralPattern = "^\\.{0,1}M{0,3}(C[MD]|D?C{0,3})(X[CL]|L?X{0,3})(I[XV]|V?I{0,3}|V?I{0,2}J)\\.{0,1}$";
    protected static String looseRomanNumeralPattern = "^\\.{0,1}M{0,3}\\.*(C[MD]|D?C{0,3})\\.*(X[CL]|L?X{0,3})(I[XVU]|[UV]?I{0,4}|[UV]?I{0,3}J)(O|M|ST|US){0,1}\\.{0,1}$";
    public static String looseOrdinalRomanNumeralPattern = "^\\.{0,1}M{0,3}\\.*(C[MD]|D?C{0,3})\\.*(X[CL]|L?X{0,3})(I[XVU]|[UV]?I{0,4}|[UV]?I{0,3}J)(th|TH|st|ST|nd|ND|rd|RD)\\.{0,1}$";
    protected static Map<Integer, String> integerToRomanMap = MapFactory.createNewMap(5000);
    protected static Map<String, Integer> romanToIntegerMap = MapFactory.createNewMap(5000);
    protected static String[] romanNumerals = new String[]{"M", "CM", "D", "CD", "C", "XC", "L", "XL", "X", "IX", "V", "IV", "I"};
    protected static int[] integerValues = new int[]{1000, 900, 500, 400, 100, 90, 50, 40, 10, 9, 5, 4, 1};

    public static boolean isRomanNumeral(String s) {
        return s.toUpperCase().matches(romanNumeralPattern);
    }

    public static boolean isLooseRomanNumeral(String s) {
        return s.toUpperCase().matches(looseRomanNumeralPattern);
    }

    public static boolean isLooseOrdinalRomanNumeral(String s) {
        return s.toUpperCase().matches(looseOrdinalRomanNumeralPattern);
    }

    public static int romanNumeralsToInteger(String s) {
        Integer i;
        int result = -1;
        if (s == null) {
            return result;
        }
        String sFixed = s.toUpperCase().replaceAll(" ", "");
        int l = sFixed.length();
        if (l > 1 && sFixed.charAt(0) == '.' && sFixed.charAt(l - 1) == '.') {
            sFixed = sFixed.substring(1, l - 1);
        }
        if ((i = romanToIntegerMap.get(sFixed)) != null) {
            result = i;
        }
        return result;
    }

    public static String integerToRomanNumerals(int i) {
        String result = "";
        String s = integerToRomanMap.get(new Integer(i));
        if (s != null) {
            result = s;
        }
        return result;
    }

    protected static String integerToRoman(int n) {
        StringBuffer result = new StringBuffer();
        int i = 0;
        while (n > 0) {
            while (n >= integerValues[i]) {
                result.append(romanNumerals[i]);
                n -= integerValues[i];
            }
            ++i;
        }
        return result.toString();
    }

    protected RomanNumeralUtils() {
    }

    static {
        for (int i = 1; i <= 5000; ++i) {
            String romanNumeral = RomanNumeralUtils.integerToRoman(i);
            romanToIntegerMap.put(romanNumeral, new Integer(i));
            integerToRomanMap.put(new Integer(i), romanNumeral);
        }
    }
}

