/*
 * Decompiled with CFR 0.152.
 */
package edu.northwestern.at.utils;

import edu.northwestern.at.utils.MapFactory;
import edu.northwestern.at.utils.UnicodeReader;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.PrintWriter;
import java.net.URL;
import java.util.Map;
import java.util.TreeSet;

public class MapUtils {
    public static Map<String, String> loadMap(URL mapURL, String separator, String qualifier, String encoding) throws IOException, FileNotFoundException {
        Map<String, String> map = MapFactory.createNewMap();
        if (mapURL != null) {
            BufferedReader bufferedReader = new BufferedReader(new UnicodeReader(mapURL.openStream(), encoding));
            String inputLine = bufferedReader.readLine();
            while (inputLine != null) {
                String[] tokens = inputLine.split(separator);
                if (tokens.length > 1) {
                    map.put(tokens[0], tokens[1]);
                }
                inputLine = bufferedReader.readLine();
            }
            bufferedReader.close();
        }
        return map;
    }

    public static Map<String, String> loadMap(File mapFile, String separator, String qualifier, String encoding) throws IOException, FileNotFoundException {
        return MapUtils.loadMap(mapFile.toURI().toURL(), separator, qualifier, encoding);
    }

    public static Map<String, String> loadMap(String mapFileName, String separator, String qualifier, String encoding) throws IOException, FileNotFoundException {
        return MapUtils.loadMap(new File(mapFileName), separator, qualifier, encoding);
    }

    public static Map<String, String> loadMap(String mapFileName) throws IOException, FileNotFoundException {
        return MapUtils.loadMap(new File(mapFileName), "\t", "", "utf-8");
    }

    public static void saveMap(Map<?, ?> map, File mapFile, String separator, String qualifier, String encoding) throws IOException, FileNotFoundException {
        if (map != null) {
            PrintWriter printWriter = new PrintWriter(mapFile, "utf-8");
            for (Object key : map.keySet()) {
                String value = map.get(key).toString();
                printWriter.println(qualifier + key + qualifier + separator + qualifier + value + qualifier);
            }
            printWriter.flush();
            printWriter.close();
        }
    }

    public static void saveMap(Map<?, ?> map, String mapFileName, String separator, String qualifier, String encoding) throws IOException, FileNotFoundException {
        MapUtils.saveMap(map, new File(mapFileName), separator, qualifier, encoding);
    }

    public static void saveMap(Map<?, ?> map, String mapFileName) throws IOException, FileNotFoundException {
        MapUtils.saveMap(map, new File(mapFileName), "\t", "", "utf-8");
    }

    public static void saveSortedMap(Map<?, ?> map, File mapFile, String separator, String qualifier, String encoding) throws IOException, FileNotFoundException {
        if (map != null) {
            PrintWriter printWriter = new PrintWriter(mapFile, "utf-8");
            TreeSet keySet = new TreeSet(map.keySet());
            for (Object key : keySet) {
                String value = map.get(key).toString();
                printWriter.println(qualifier + key + qualifier + separator + qualifier + value + qualifier);
            }
            printWriter.flush();
            printWriter.close();
        }
    }

    public static void saveSortedMap(Map<?, ?> map, String mapFileName, String separator, String qualifier, String encoding) throws IOException, FileNotFoundException {
        MapUtils.saveSortedMap(map, new File(mapFileName), separator, qualifier, encoding);
    }

    protected MapUtils() {
    }
}

