/*
 * Decompiled with CFR 0.152.
 */
package edu.northwestern.at.utils;

import edu.northwestern.at.utils.CompoundKey;
import edu.northwestern.at.utils.Map2D;
import edu.northwestern.at.utils.Map2DFactory;
import edu.northwestern.at.utils.UnicodeReader;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.PrintWriter;
import java.net.URL;

public class Map2DUtils {
    public static Map2D<String, String, String> loadMap2D(URL map2DURL, String separator, String qualifier, String encoding) throws IOException, FileNotFoundException {
        Map2D<String, String, String> map2D = Map2DFactory.createNewMap2D();
        if (map2DURL != null) {
            BufferedReader bufferedReader = new BufferedReader(new UnicodeReader(map2DURL.openStream(), encoding));
            String inputLine = bufferedReader.readLine();
            while (inputLine != null) {
                String[] tokens = inputLine.split(separator);
                if (tokens.length > 2) {
                    map2D.put(tokens[0], tokens[1], tokens[2]);
                }
                inputLine = bufferedReader.readLine();
            }
            bufferedReader.close();
        }
        return map2D;
    }

    public static Map2D<String, String, String> loadMap2D(File mapFile, String separator, String qualifier, String encoding) throws IOException, FileNotFoundException {
        return Map2DUtils.loadMap2D(mapFile.toURI().toURL(), separator, qualifier, encoding);
    }

    public static Map2D<String, String, String> loadMap2D(String mapFileName, String separator, String qualifier, String encoding) throws IOException, FileNotFoundException {
        return Map2DUtils.loadMap2D(new File(mapFileName), separator, qualifier, encoding);
    }

    public static void saveMap2D(Map2D<?, ?, ?> map2D, File mapFile, String separator, String qualifier, String encoding) throws IOException, FileNotFoundException {
        if (map2D != null) {
            PrintWriter printWriter = new PrintWriter(mapFile, "utf-8");
            for (CompoundKey key : map2D.keySet()) {
                String value = map2D.get(key).toString();
                Comparable[] keyValues = key.getKeyValues();
                printWriter.println(qualifier + keyValues[0] + qualifier + separator + qualifier + keyValues[1] + qualifier + separator + qualifier + value + qualifier);
            }
            printWriter.flush();
            printWriter.close();
        }
    }

    public static void saveMap2D(Map2D<?, ?, ?> map2D, String mapFileName, String separator, String qualifier, String encoding) throws IOException, FileNotFoundException {
        Map2DUtils.saveMap2D(map2D, new File(mapFileName), separator, qualifier, encoding);
    }

    protected Map2DUtils() {
    }
}

