/*
 * Decompiled with CFR 0.152.
 */
package edu.northwestern.at.utils;

import edu.northwestern.at.utils.FileUtils;
import edu.northwestern.at.utils.ListFactory;
import edu.northwestern.at.utils.StringUtils;
import edu.northwestern.at.utils.URLUtils;
import edu.northwestern.at.utils.net.mime.MimeTypeMapper;
import java.io.File;
import java.io.FilenameFilter;
import java.util.Arrays;
import java.util.Formatter;
import java.util.List;

public class FileNameUtils {
    public static MimeTypeMapper mimeTypeMapper = new MimeTypeMapper();
    public static final String FILE_SEPARATOR = System.getProperty("file.separator");

    public static String stripPathName(String fileName) {
        return new File(fileName).getName();
    }

    public static String changeFileExtension(String fileName, String newExtension) {
        String result = null;
        if (fileName != null && newExtension != null) {
            int periodPos;
            String extension = newExtension;
            if (extension.length() > 0 && extension.charAt(0) != '.') {
                extension = '.' + extension;
            }
            result = (periodPos = fileName.lastIndexOf(46)) >= 0 ? fileName.substring(0, periodPos) + extension : fileName + extension;
        }
        return result;
    }

    public static String getFileExtension(String fileName, boolean keepPeriod) {
        String name = FileNameUtils.stripPathName(StringUtils.safeString(fileName));
        int periodPos = name.lastIndexOf(46);
        String extension = periodPos != -1 ? (keepPeriod ? name.substring(periodPos) : name.substring(periodPos + 1)) : "";
        return extension;
    }

    public static String getContentTypeFor(String fileName) {
        return mimeTypeMapper.getContentTypeFor(fileName);
    }

    public static boolean fileExists(String fileName) {
        return new File(fileName).exists();
    }

    public static String[] expandWildcards(String fileSpec) {
        Object[] result = new String[]{};
        String fileName = fileSpec;
        int wildIndex = fileName.indexOf("*");
        if (wildIndex == -1) {
            if (new File(fileName).exists()) {
                result = new String[]{fileName};
            }
        } else {
            fileName = StringUtils.replaceAll(fileName, "**", "*");
            wildIndex = fileName.indexOf("*");
            int index = fileName.lastIndexOf(FILE_SEPARATOR);
            String path = "";
            path = index > 0 ? fileName.substring(0, index) : FileUtils.getCurrentDirectory();
            File pathDir = new File(path);
            if (pathDir.exists()) {
                final String prefix = fileName.substring(index + 1, wildIndex);
                String suff = "";
                if (wildIndex + 1 < fileName.length()) {
                    suff = fileName.substring(wildIndex + 1, fileName.length());
                }
                final String suffix = suff;
                Object[] listFiles = pathDir.list(new FilenameFilter(){

                    @Override
                    public boolean accept(File cwd, String name) {
                        return name.startsWith(prefix) && name.endsWith(suffix);
                    }
                });
                for (int i = 0; i < listFiles.length; ++i) {
                    listFiles[i] = path.concat(FILE_SEPARATOR + (String)listFiles[i]);
                }
                if (listFiles.length > 0) {
                    Arrays.sort(listFiles);
                    result = listFiles;
                }
            }
        }
        return result;
    }

    public static String fixFileSeparators(String fileName) {
        String fixedFileName = "";
        if (FILE_SEPARATOR.equals("\\")) {
            fixedFileName = StringUtils.replaceAll(fileName, "\\", "<backslash>");
            fixedFileName = StringUtils.replaceAll(fixedFileName, "<backslash>", "\\\\");
        } else {
            fixedFileName = fileName;
        }
        return fixedFileName;
    }

    public static String[] expandFileNameWildcards(String[] wildCardNames) {
        List<String> fileNames = ListFactory.createNewList();
        for (int i = 0; i < wildCardNames.length; ++i) {
            if (URLUtils.isURL(wildCardNames[i])) {
                fileNames.add(wildCardNames[i]);
                continue;
            }
            String[] expandedFileNames = FileNameUtils.expandWildcards(wildCardNames[i]);
            fileNames.addAll(Arrays.asList(expandedFileNames));
        }
        Object[] result = fileNames.toArray(new String[fileNames.size()]);
        Arrays.sort(result);
        return result;
    }

    public static String createVersionedFileName(String fileName) {
        String result = fileName;
        if (new File(fileName).exists()) {
            result = FileNameUtils.createVersionedFileName(fileName, 1, "%03d");
        }
        return result;
    }

    public static String createVersionedFileName(String fileName, int versionNumber, String versionFormat) {
        int n = fileName.lastIndexOf(46);
        StringBuilder sb = new StringBuilder();
        new Formatter(sb).format(versionFormat, versionNumber);
        String sVersionNumber = sb.toString();
        String versionedFileName = fileName + "-" + sVersionNumber;
        if (n >= 0) {
            versionedFileName = fileName.substring(0, n) + "-" + sVersionNumber + fileName.substring(n, fileName.length());
        }
        if (new File(versionedFileName).exists()) {
            versionedFileName = FileNameUtils.createVersionedFileName(fileName, ++versionNumber, versionFormat);
        }
        return versionedFileName;
    }

    private FileNameUtils() {
        throw new UnsupportedOperationException();
    }
}

