/*
 * Decompiled with CFR 0.152.
 */
package edu.northwestern.at.utils;

import edu.northwestern.at.utils.FileNameUtils;
import edu.northwestern.at.utils.Formatters;
import java.io.BufferedOutputStream;
import java.io.OutputStream;
import java.io.PrintStream;

public abstract class FileBatchProcessor {
    protected int initParams = 1;
    protected int filesToProcess = 0;
    protected int currentFileNumber = 0;
    protected String outputDirectoryName = "";
    protected String[] fileNames = null;
    protected PrintStream printStream;

    public FileBatchProcessor() throws Exception {
        this.initialize();
    }

    public void run() {
        try {
            long startTime = System.currentTimeMillis();
            int filesProcessed = this.processFiles();
            long processingTime = (System.currentTimeMillis() - startTime + 999L) / 1000L;
            this.terminate(filesProcessed, processingTime);
        }
        catch (Exception e) {
            this.printStream.println(e.getMessage());
        }
    }

    public boolean initialize() throws Exception {
        this.printStream = new PrintStream((OutputStream)new BufferedOutputStream(System.out), true, "utf-8");
        return true;
    }

    public abstract void processOneFile(String var1) throws Exception;

    public int processFiles() throws Exception {
        boolean result = false;
        if (this.fileNames != null) {
            this.filesToProcess = this.fileNames.length;
            for (int i = 0; i < this.fileNames.length; ++i) {
                this.processOneFile(this.fileNames[i]);
            }
        }
        return this.fileNames.length;
    }

    public void terminate(int filesProcessed, long processingTime) {
        this.printStream.println("Processed " + Formatters.formatIntegerWithCommas(filesProcessed) + " files in " + Formatters.formatLongWithCommas(processingTime) + " seconds.");
    }

    public void setOutputDirectoryName(String outputDirectoryName) {
        this.outputDirectoryName = outputDirectoryName;
    }

    public String getOutputDirectoryName() {
        return this.outputDirectoryName;
    }

    public void setInputFileNames(String[] inputFileNames, int startIndex) {
        String[] wildcards = new String[inputFileNames.length - startIndex];
        for (int i = startIndex; i < inputFileNames.length; ++i) {
            wildcards[i - startIndex] = inputFileNames[i];
        }
        this.fileNames = FileNameUtils.expandFileNameWildcards(wildcards);
    }

    public int getNumberOfFilesToProcess() {
        return this.filesToProcess;
    }

    public int getCurrentFileNumber() {
        return this.currentFileNumber;
    }

    public void setCurrentFileNumber(int currentFileNumber) {
        this.currentFileNumber = currentFileNumber;
    }

    public void incrementCurrentFileNumber() {
        ++this.currentFileNumber;
    }

    public PrintStream getPrintStream() {
        return this.printStream;
    }
}

