/*
 * Decompiled with CFR 0.152.
 */
package edu.northwestern.at.utils;

import edu.northwestern.at.utils.StringUtils;
import java.awt.Component;
import java.awt.Container;
import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.util.Iterator;
import java.util.Map;

public class DebugUtils {
    public static String activeThreads() {
        StringBuffer sb = new StringBuffer();
        Thread[] threads = new Thread[Thread.activeCount()];
        int num = Thread.enumerate(threads);
        for (int i = 0; i < num; ++i) {
            sb.append(i + " : " + threads[i] + "\n");
        }
        return StringUtils.trim(sb.toString());
    }

    public static String getStackTrace(Throwable e) {
        ByteArrayOutputStream traceByteArrayStream = new ByteArrayOutputStream();
        PrintStream tracePrintStream = new PrintStream(traceByteArrayStream);
        e.printStackTrace(tracePrintStream);
        tracePrintStream.flush();
        return traceByteArrayStream.toString();
    }

    public static Component printChildComponents(Container parent, int indent) {
        if (parent == null) {
            return null;
        }
        if (parent instanceof Container) {
            Component[] comps = parent.getComponents();
            for (int i = 0; i < comps.length; ++i) {
                System.out.println(StringUtils.dupl(' ', indent) + comps[i].toString());
                if (!(comps[i] instanceof Container)) continue;
                return DebugUtils.printChildComponents((Container)comps[i], indent + 1);
            }
        } else {
            System.out.println(StringUtils.dupl(' ', indent) + parent.toString());
        }
        return null;
    }

    public static void printNullity(String methodName, String objectName, Object object) {
        if (object == null) {
            System.out.println(methodName + ": " + objectName + " is null.");
        } else {
            System.out.println(methodName + ": " + objectName + " is not null.");
        }
    }

    public static <K, V> void printMap(String mapLabel, Map<K, V> map) {
        if (map == null) {
            System.out.println(mapLabel + " is null.");
        } else if (map.size() == 0) {
            System.out.println(mapLabel + " is empty.");
        } else {
            System.out.println(mapLabel);
            Iterator<K> iterator = map.keySet().iterator();
            int i = 0;
            while (iterator.hasNext()) {
                K key = iterator.next();
                V value = map.get(key);
                if (key == null) {
                    if (value == null) {
                        System.out.println(i + ": null=null");
                    } else {
                        System.out.println(i + ": null=" + value.toString());
                    }
                } else if (value == null) {
                    System.out.println(i + ": " + key.toString() + "=null");
                } else {
                    System.out.println(i + ": " + key.toString() + "=" + value.toString());
                }
                ++i;
            }
        }
    }

    public static void printArray(String arrayLabel, Object[] array) {
        if (array == null) {
            System.out.println(arrayLabel + " is null.");
        } else if (array.length == 0) {
            System.out.println(arrayLabel + " is empty.");
        } else {
            System.out.println(arrayLabel);
            for (int i = 0; i < array.length; ++i) {
                Object value = array[i];
                if (value == null) {
                    System.out.println(i + ": null");
                    continue;
                }
                System.out.println(i + ": " + value.toString());
            }
        }
    }

    public static void printMemoryStatus(String title) {
        Runtime runTime = Runtime.getRuntime();
        long freeMem = runTime.freeMemory();
        long totalMem = runTime.totalMemory();
        System.out.println(title == null ? "" : title + ": " + "Memory status: free memory=" + StringUtils.formatNumberWithCommas(freeMem) + ", total memory=" + StringUtils.formatNumberWithCommas(totalMem));
    }

    public static void printThreads() {
        System.out.println(DebugUtils.activeThreads());
    }

    protected DebugUtils() {
    }
}

