/*
 * Decompiled with CFR 0.152.
 */
package edu.northwestern.at.utils;

import edu.northwestern.at.utils.SetFactory;
import java.text.Normalizer;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class CharUtils {
    protected static Set<Integer> punctuationSet;
    protected static Set<Integer> symbolSet;
    protected static Set<Integer> superscriptSet;
    protected static Set<Integer> subscriptSet;
    public static final char PARAGRAPH = '\u00b6';
    public static final String PARAGRAPH_STRING = "\u00b6";
    public static final char SECTION_SIGN = '\u00a7';
    public static final String SECTION_SIGN_STRING = "\u00a7";
    public static final char LSQUOTE = '\u2018';
    public static final String LSQUOTE_STRING = "\u2018";
    public static final char RSQUOTE = '\u2019';
    public static final String RSQUOTE_STRING = "\u2019";
    public static final char RLSQUOTE = '\u201a';
    public static final String RLSQUOTE_STRING = "\u201a";
    public static final char LDQUOTE = '\u201c';
    public static final String LDQUOTE_STRING = "\u201c";
    public static final char RDQUOTE = '\u201d';
    public static final String RDQUOTE_STRING = "\u201d";
    public static final char SOLIDCIRCLE = '\u2022';
    public static final String SOLIDCIRCLE_STRING = "\u2022";
    public static final char BLACKCIRCLE = '\u25cf';
    public static final String BLACKCIRCLE_STRING = "\u25cf";
    public static final char DEGREES_MARK = '\u2032';
    public static final String DEGREES_MARK_STRING = "\u2032";
    public static final char MINUTES_MARK = '\u2033';
    public static final char SECONDS_MARK = '\u2034';
    public static final char CHAR_GAP_MARKER = '\u25cf';
    public static final String CHAR_GAP_MARKER_STRING = "\u25cf";
    public static final char CHAR_END_OF_TEXT_SECTION = '\ue500';
    public static final String CHAR_END_OF_TEXT_SECTION_STRING = "\ue500";
    public static final char CHAR_FAKE_SOFT_HYPHEN = '\ue501';
    public static final String CHAR_FAKE_SOFT_HYPHEN_STRING = "\ue501";
    public static final char CHAR_SUBSTITUTE_SINGLE_QUOTE = '\ue502';
    public static final String CHAR_SUBSTITUTE_SINGLE_QUOTE_STRING = "\ue502";
    public static final char CHAR_SUP_TEXT_MARKER = '\ue503';
    public static final String CHAR_SUP_TEXT_MARKER_STRING = "\ue503";
    public static final char LONG_DASH = '\u2014';
    public static final String LONG_DASH_STRING = "\u2014";
    public static final char SHORT_DASH = '\u2010';
    public static final String SHORT_DASH_STRING = "\u2010";
    public static final char OLD_EURO_SIGN = '\u20a0';
    public static final char EURO_SIGN = '\u20ac';
    public static final char UNKNOWN_PUNC = '\u25aa';
    public static final char COMBINING_MACRON = '\u0304';
    public static final String COMBINING_MACRON_STRING = "\u0304";
    public static final char NONBREAKING_BLANK = '\u00a0';
    public static final String NONBREAKING_BLANK_STRING = "\u00a0";
    public static final char NONBREAKING_HYPHEN = '\u2011';
    public static final String NONBREAKING_HYPHEN_STRING = "\u2011";
    public static final char VERTICAL_BAR = '|';
    public static final String VERTICAL_BAR_STRING = "|";
    public static final char BROKEN_VERTICAL_BAR = '\u00a6';
    public static final String BROKEN_VERTICAL_BAR_STRING = "\u00a6";
    public static final char LIGHT_VERTICAL_BAR = '\u2758';
    public static final String LIGHT_VERTICAL_BAR_STRING = "\u2758";
    public static final char DIVIDER_VERTICAL_BAR = '\u2223';
    public static final String DIVIDER_VERTICAL_BAR_STRING = "\u2223";
    public static final char ELLIPSIS = '\u2026';
    public static final String ELLIPSIS_STRING = "\u2026";
    public static final char SOLAR_CIRCLE = '\u2299';
    public static final String SOLAR_CIRCLE_STRING = "\u2299";
    public static final char DOTTEDCIRCLE = '\u25cc';
    public static final String DOTTEDCIRCLE_STRING = "\u25cc";
    public static final char LEFT_ANGLE_BRACKET = '\u3008';
    public static final String LEFT_ANGLE_BRACKET_STRING = "\u3008";
    public static final char RIGHT_ANGLE_BRACKET = '\u3009';
    public static final String RIGHT_ANGLE_BRACKET_STRING = "\u3009";
    public static final char LOZENGE = '\u25ca';
    public static final String LOZENGE_STRING = "\u25ca";
    public static final char ASTERISM = '\u2042';
    public static final String ASTERISM_STRING = "\u2042";
    public static final char DAGGER = '\u2020';
    public static final String DAGGER_STRING = "\u2020";
    public static final char DOUBLE_DAGGER = '\u2021';
    public static final String DOUBLE_DAGGER_STRING = "\u2021";
    public static final char INVISIBLE_SEPARATOR = '\u2063';
    public static final String INVISIBLE_SEPARATOR_STRING = "\u2063";
    public static final String SPAN_GAP_MARKER = "\u3008\u2026\u3009";
    public static final char LONG_S = '\u017f';
    public static final String LONG_S_STRING = "\u017f";
    public static String digitsPattern;
    public static String ordinalNumberPattern;
    protected static final Pattern hyphenPattern;
    protected static final Matcher hyphenMatcher;
    protected static final Pattern asteriskPattern;
    protected static final Matcher asteriskMatcher;
    protected static final Pattern possessiveAsteriskPattern;
    protected static final Matcher possessiveAsteriskMatcher;
    protected static final Pattern possessiveDashesPattern;
    protected static final Matcher possessiveDashesMatcher;
    protected static final Pattern wordPattern;
    protected static final Matcher wordMatcher;
    protected static final Pattern lettersPattern;
    protected static final Matcher lettersMatcher;
    protected static final Pattern punctuationPattern;
    protected static final Matcher punctuationMatcher;

    public static boolean isLetter(char c) {
        return Character.isLetter(c);
    }

    public static boolean isLetter(String s) {
        return s != null && s.length() == 1 && Character.isLetter(s.charAt(0));
    }

    public static boolean isLetters(String s) {
        boolean result = false;
        if (s != null) {
            lettersMatcher.reset(s.trim());
            result = lettersMatcher.matches();
        }
        return result;
    }

    public static boolean isAWord(String s) {
        boolean result = false;
        if (s != null && !s.equals("'")) {
            wordMatcher.reset(s);
            result = wordMatcher.matches();
        }
        return result;
    }

    public static boolean isCapitalLetter(char c) {
        return Character.isLetter(c) && Character.isUpperCase(c);
    }

    public static boolean isPunctuation(char ch) {
        return punctuationSet.contains(new Integer(Character.getType(ch))) || ch == '`' || ch == '\u25aa';
    }

    public static boolean isPunctuation(String s) {
        boolean result = false;
        if (s != null) {
            punctuationMatcher.reset(s.trim());
            result = punctuationMatcher.matches();
        }
        return result;
    }

    public static boolean isSymbol(char ch) {
        return symbolSet.contains(new Integer(Character.getType(ch)));
    }

    public static boolean isSymbol(String s) {
        boolean result = true;
        String ts = s.trim();
        for (int i = 0; i < ts.length(); ++i) {
            if (CharUtils.isSymbol(ts.charAt(i))) continue;
            result = false;
            break;
        }
        return result;
    }

    public static boolean isPunctuationOrSymbol(char c) {
        return CharUtils.isPunctuation(c) || CharUtils.isSymbol(c);
    }

    public static boolean isPunctuationOrSymbol(String s) {
        boolean result = true;
        String ts = s.trim();
        for (int i = 0; i < ts.length(); ++i) {
            if (CharUtils.isPunctuationOrSymbol(ts.charAt(i))) continue;
            result = false;
            break;
        }
        return result;
    }

    public static boolean isDigit(char c) {
        return Character.isDigit(c);
    }

    public static boolean isDigits(String s) {
        if (s == null) {
            return false;
        }
        boolean result = true;
        String ts = s.trim();
        for (int i = 0; i < ts.length(); ++i) {
            if (CharUtils.isDigit(s.charAt(i))) continue;
            result = false;
            break;
        }
        return result;
    }

    public static boolean hasDigit(String s) {
        if (s == null) {
            return false;
        }
        boolean result = false;
        String ts = s.trim();
        for (int i = 0; i < ts.length(); ++i) {
            if (!CharUtils.isDigit(s.charAt(i))) continue;
            result = true;
            break;
        }
        return result;
    }

    public static boolean isDash(char c) {
        return Character.getType(c) == 20;
    }

    public static boolean isBreakingDash(char c) {
        return CharUtils.isDash(c) && c != '\u2011' && c != '\u2014';
    }

    public static boolean hasDash(String s) {
        boolean result = false;
        for (int i = 0; i < s.length(); ++i) {
            boolean bl = result = Character.getType(s.charAt(i)) == 20;
            if (result) break;
        }
        return result;
    }

    public static String evictDashes(String s) {
        StringBuffer result = new StringBuffer();
        for (int i = 0; i < s.length(); ++i) {
            if (Character.getType(s.charAt(i)) == 20) continue;
            result.append(s.charAt(i));
        }
        return result.toString();
    }

    public static boolean isNumber(String s) {
        boolean result = false;
        if (s != null) {
            try {
                double x = Double.parseDouble(s);
                result = true;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return result;
    }

    public static boolean isOrdinal(String s) {
        boolean result = false;
        if (s != null) {
            result = s.matches(ordinalNumberPattern);
        }
        return result;
    }

    public static boolean allLettersCapital(String s) {
        boolean result = false;
        String ts = s.trim();
        int l = ts.length();
        for (int i = 0; i < l; ++i) {
            char ch = ts.charAt(i);
            if (!Character.isLetter(ch)) continue;
            if (!Character.isUpperCase(ch)) {
                result = false;
                break;
            }
            result = true;
        }
        return result;
    }

    public static boolean isUpperCase(String s) {
        boolean result = true;
        String ts = s.trim();
        for (int i = 0; i < ts.length(); ++i) {
            if (Character.isUpperCase(ts.charAt(i))) continue;
            result = false;
            break;
        }
        return result;
    }

    public static boolean isFirstLetterCapital(String s) {
        boolean result = false;
        String ts = s.trim();
        for (int i = 0; i < ts.length(); ++i) {
            if (!Character.isLetter(ts.charAt(i))) continue;
            result = Character.isUpperCase(ts.charAt(i));
            break;
        }
        return result;
    }

    public static boolean hasPunctuation(String s) {
        boolean result = false;
        String ts = s.trim();
        for (int i = 0; i < ts.length(); ++i) {
            char ch = ts.charAt(i);
            if (!CharUtils.isPunctuation(ch) || ch == '-') continue;
            result = true;
            break;
        }
        return result;
    }

    public static boolean hasPunctuationNotApostrophes(String s) {
        boolean result = false;
        String ts = s.trim();
        for (int i = 0; i < ts.length(); ++i) {
            char ch = ts.charAt(i);
            if (!CharUtils.isPunctuation(ch) || ch == '-' || ch == '\'') continue;
            result = true;
            break;
        }
        return result;
    }

    public static boolean hasSymbols(String s) {
        boolean result = false;
        String ts = s.trim();
        for (int i = 0; i < ts.length(); ++i) {
            char ch = ts.charAt(i);
            if (!CharUtils.isSymbol(ch)) continue;
            result = true;
            break;
        }
        return result;
    }

    public static boolean isGapMarker(char c) {
        return c == '\u25cf';
    }

    public static boolean hasGapMarkers(String s) {
        boolean result = false;
        String ts = s.trim();
        for (int i = 0; i < ts.length(); ++i) {
            char ch = ts.charAt(i);
            if (!CharUtils.isGapMarker(ch)) continue;
            result = true;
            break;
        }
        return result;
    }

    public static boolean isGreekLetter(char c) {
        return c >= '\u0370' && c < '\u0400' || c >= '\u1f00' && c < '\u2000';
    }

    public static boolean hasGreekLetters(String s) {
        boolean result = false;
        String ts = s.trim();
        for (int i = 0; i < ts.length(); ++i) {
            char ch = ts.charAt(i);
            if (!CharUtils.isGreekLetter(ch)) continue;
            result = true;
            break;
        }
        return result;
    }

    public static boolean isEnglishVowel(char c) {
        return c == 'a' || c == 'e' || c == 'i' || c == 'o' || c == 'u';
    }

    public static boolean isSingleQuote(char c) {
        return c == '\'' || c == '\u2018' || c == '\u2019';
    }

    public static boolean isApostrophe(char c) {
        return c == '\'';
    }

    public static boolean isSingleOpeningQuote(char c) {
        return c == '\'' || c == '\u2018';
    }

    public static boolean endsWithSingleQuoteS(String s) {
        int l = s.length();
        return l > 1 && (s.charAt(l - 1) == 's' || s.charAt(l - 1) == 'S') && CharUtils.isSingleQuote(s.charAt(l - 2));
    }

    public static boolean isSingleQuoteS(String s) {
        int l = s.length();
        return l == 2 && CharUtils.isSingleQuote(s.charAt(0)) && (s.charAt(1) == 's' || s.charAt(1) == 'S');
    }

    public static boolean endsWithSingleQuote(String s) {
        int l = s.length();
        return l > 0 && CharUtils.isSingleQuote(s.charAt(l - 1));
    }

    public static boolean isOpeningQuote(char c) {
        return c == '\'' || c == '\u2018' || c == '\u201c';
    }

    public static boolean isClosingQuote(char c) {
        return c == '\'' || c == '\"' || c == '\u2019' || c == '\u201d';
    }

    public static boolean hasSingleQuote(String s) {
        boolean result = false;
        for (int i = 0; i < s.length(); ++i) {
            boolean bl = result = result || CharUtils.isSingleQuote(s.charAt(i));
            if (result) break;
        }
        return result;
    }

    public static boolean isAllCaps(String s) {
        boolean result = true;
        for (int i = 0; i < s.length(); ++i) {
            char ch = s.charAt(i);
            if (!Character.isLetter(ch)) continue;
            boolean bl = result = result && Character.isUpperCase(ch);
            if (!result) break;
        }
        return result;
    }

    public static boolean isAllLowerCase(String s) {
        boolean result = true;
        for (int i = 0; i < s.length(); ++i) {
            char ch = s.charAt(i);
            if (!Character.isLetter(ch)) continue;
            boolean bl = result = result && Character.isLowerCase(ch);
            if (!result) break;
        }
        return result;
    }

    public static boolean hasCapitalLetter(String s) {
        boolean result = false;
        for (int i = 0; i < s.length(); ++i) {
            char ch = s.charAt(i);
            boolean bl = result = result || Character.isLetter(ch) && Character.isUpperCase(ch);
            if (result) break;
        }
        return result;
    }

    public static boolean hasApostrophe(String s) {
        return s.indexOf("'") >= 0;
    }

    public static boolean hasPeriod(String s) {
        return s.indexOf(".") >= 0;
    }

    public static boolean hasGapCharacter(String s) {
        return s.indexOf(9679) >= 0;
    }

    public static boolean hasInternalCaps(String s) {
        boolean result = false;
        for (int i = 1; i < s.length(); ++i) {
            char ch = s.charAt(i);
            boolean bl = result = result || Character.isLetter(ch) && Character.isUpperCase(ch);
            if (result) break;
        }
        return result;
    }

    public static boolean isAllPeriods(String s) {
        return s.matches("^(\\.{1,})$");
    }

    public static synchronized boolean isAllHyphens(String s) {
        hyphenMatcher.reset(s);
        return hyphenMatcher.matches();
    }

    public static synchronized boolean isAllAsterisks(String s) {
        asteriskMatcher.reset(s);
        return asteriskMatcher.matches();
    }

    public static synchronized boolean isPossessiveAsterisks(String s) {
        possessiveAsteriskMatcher.reset(s);
        return possessiveAsteriskMatcher.matches();
    }

    public static synchronized boolean isPossessiveDashes(String s) {
        possessiveDashesMatcher.reset(s);
        return possessiveDashesMatcher.matches();
    }

    public static boolean isWhitespace(char c) {
        return Character.isWhitespace(c);
    }

    public static String makeCaseMatch(String s, String sCaseToMatch) {
        String result = s;
        if (CharUtils.isAllCaps(sCaseToMatch)) {
            result = result.toUpperCase();
        } else {
            boolean isCapitalized = false;
            if (sCaseToMatch.length() > 0) {
                isCapitalized = CharUtils.isSingleQuote(sCaseToMatch.charAt(0)) ? sCaseToMatch.length() > 1 && CharUtils.isCapitalLetter(sCaseToMatch.charAt(1)) : CharUtils.isCapitalLetter(sCaseToMatch.charAt(0));
            }
            if (result.length() > 0) {
                if (CharUtils.isSingleQuote(result.charAt(0))) {
                    String char0 = result.charAt(0) + "";
                    String rest = "";
                    if (result.length() > 1) {
                        char char1 = result.charAt(1);
                        if (result.length() > 2) {
                            rest = result.substring(2);
                        }
                        result = isCapitalized ? char0 + Character.toUpperCase(char1) + rest : char0 + Character.toLowerCase(char1) + rest;
                    }
                } else {
                    String rest = "";
                    char char0 = result.charAt(0);
                    if (result.length() > 1) {
                        rest = result.substring(1);
                    }
                    result = isCapitalized ? Character.toUpperCase(char0) + rest : Character.toLowerCase(char0) + rest;
                }
            }
        }
        return result;
    }

    public static String capitalizeFirstLetter(String s) {
        char[] chars = s.toLowerCase().toCharArray();
        for (int i = 0; i < chars.length; ++i) {
            char ch = chars[i];
            if (!Character.isLetter(ch)) continue;
            chars[i] = Character.toUpperCase(ch);
            break;
        }
        return new String(chars);
    }

    public static boolean isUSCurrency(String token) {
        return token.matches("^\\s*[$]?\\s*((\\d+)|(\\d{1,3}(\\,\\d{3})+))(\\.\\d{2})?\\s*$");
    }

    public static boolean isUSCurrencyCents(String token) {
        return token.matches("([\\+\\-]*)([0-9\\,]+)\u00a2$");
    }

    public static boolean isCurrency(String token) {
        return token.matches("^-?[\u00a3\\$L\u20ac ]*[0-9\\.\\,]+[lL]*$");
    }

    public static String getCaseOld(String s) {
        String result = "0";
        if (CharUtils.allLettersCapital(s)) {
            result = "3";
        } else if (CharUtils.isFirstLetterCapital(s)) {
            result = "1";
        } else if (CharUtils.hasInternalCaps(s)) {
            result = "2";
        }
        return result;
    }

    public static int getLetterCase(String s) {
        int result = 0;
        int capLetCount = 0;
        int letCount = 0;
        for (int i = 0; i < s.length(); ++i) {
            char ch = s.charAt(i);
            if (!Character.isLetter(ch)) continue;
            ++letCount;
            if (!Character.isUpperCase(ch)) continue;
            if (letCount == 1) {
                result = 1;
            }
            ++capLetCount;
        }
        if (letCount == capLetCount) {
            result = 3;
        } else if (result == 0 && capLetCount > 0) {
            result = 2;
        }
        return result;
    }

    public static String normalizeString(String s) {
        return s == null ? null : Normalizer.normalize(s, Normalizer.Form.NFKD).replaceAll("\\p{InCombiningDiacriticalMarks}+", "");
    }

    public static boolean isSuperscript(char ch) {
        return superscriptSet.contains(ch);
    }

    public static boolean isSubscript(char ch) {
        return subscriptSet.contains(ch);
    }

    protected CharUtils() {
    }

    static {
        int i;
        punctuationSet = SetFactory.createNewSet();
        symbolSet = SetFactory.createNewSet();
        superscriptSet = SetFactory.createNewSet();
        subscriptSet = SetFactory.createNewSet();
        digitsPattern = "[0-9]*";
        ordinalNumberPattern = "[0-9][0-9,]*(th|TH|st|ST|nd|ND|rd|RD)";
        hyphenPattern = Pattern.compile("^([-\u2011]{1,})$");
        hyphenMatcher = hyphenPattern.matcher("");
        asteriskPattern = Pattern.compile("^(\\*{1,})$");
        asteriskMatcher = asteriskPattern.matcher("");
        possessiveAsteriskPattern = Pattern.compile("^(\\*{1,})'(s|S)$");
        possessiveAsteriskMatcher = possessiveAsteriskPattern.matcher("");
        possessiveDashesPattern = Pattern.compile("^([-\u2011]{2,})'(s|S)$");
        possessiveDashesMatcher = possessiveDashesPattern.matcher("");
        wordPattern = Pattern.compile("([\\w]+|([\\w]+-[\\w]+)+|[\\w]*'[\\w]*)");
        wordMatcher = wordPattern.matcher("");
        lettersPattern = Pattern.compile("^[\\pL\\pN]+$");
        lettersMatcher = lettersPattern.matcher("");
        punctuationPattern = Pattern.compile("^[\\p{Punct}]+$|[\\p{P}]+$");
        punctuationMatcher = punctuationPattern.matcher("");
        punctuationSet.add(new Integer(23));
        punctuationSet.add(new Integer(20));
        punctuationSet.add(new Integer(7));
        punctuationSet.add(new Integer(22));
        punctuationSet.add(new Integer(30));
        punctuationSet.add(new Integer(29));
        punctuationSet.add(new Integer(24));
        punctuationSet.add(new Integer(14));
        punctuationSet.add(new Integer(21));
        symbolSet.add(new Integer(26));
        symbolSet.add(new Integer(25));
        symbolSet.add(new Integer(27));
        symbolSet.add(new Integer(28));
        symbolSet.add(new Integer(18));
        for (i = 8304; i <= 8313; ++i) {
            superscriptSet.add(i);
        }
        for (i = 8320; i <= 8329; ++i) {
            subscriptSet.add(i);
        }
    }
}

