/*
 * Decompiled with CFR 0.152.
 */
package edu.northwestern.at.utils;

import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.EOFException;
import java.io.File;
import java.io.FileDescriptor;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.io.Reader;
import java.io.UTFDataFormatException;
import java.io.Writer;

public class BufferedRandomAccessFile
implements DataInput,
DataOutput {
    protected FileBufferStruct currBuf;
    protected FileBufferStruct altBuf;
    RandomAccessFile delegate;

    public BufferedRandomAccessFile(File file, String mode, int bufferSize) throws IOException {
        this(file, mode);
        if (bufferSize < 1) {
            throw new Error("Buffer size must be at least 1");
        }
        this.currBuf = new FileBufferStruct();
        this.altBuf = new FileBufferStruct();
        this.currBuf.bytes = new byte[bufferSize];
        this.currBuf.filePos = this.delegate.getFilePointer();
        this.currBuf.modified = false;
        this.altBuf.bytes = new byte[bufferSize];
        this.altBuf.filePos = -1L;
        this.fillBuffer();
    }

    protected BufferedRandomAccessFile(File file, String mode) throws IOException {
        this.delegate = new RandomAccessFile(file, mode);
    }

    public void setLength(long newLength) throws IOException {
        this.delegate.setLength(newLength);
        if (newLength < this.currBuf.filePos) {
            this.currBuf.filePos = newLength;
            this.currBuf.pos = 0;
            this.currBuf.dataLen = 0;
        } else if (newLength < this.currBuf.filePos + (long)this.currBuf.dataLen) {
            this.currBuf.dataLen = (int)(newLength - this.currBuf.filePos);
            if (this.currBuf.dataLen > this.currBuf.pos) {
                this.currBuf.pos = this.currBuf.dataLen;
            }
        }
    }

    public Reader getReader() {
        return new Reader(){

            @Override
            public void close() throws IOException {
                BufferedRandomAccessFile.this.close();
            }

            @Override
            public void mark(int readAhreadLimit) throws IOException {
                throw new IOException("mark not supported");
            }

            @Override
            public boolean markSupported() {
                return false;
            }

            @Override
            public int read() throws IOException {
                return BufferedRandomAccessFile.this.readChar();
            }

            @Override
            public int read(char[] buf) throws IOException {
                return this.read(buf, 0, buf.length);
            }

            @Override
            public int read(char[] buf, int pos, int len) throws IOException {
                for (int i = 0; i < len; ++i) {
                    buf[pos + i] = BufferedRandomAccessFile.this.readChar();
                }
                return len;
            }

            @Override
            public boolean ready() throws IOException {
                return BufferedRandomAccessFile.this.currBuf.pos < BufferedRandomAccessFile.this.currBuf.dataLen || BufferedRandomAccessFile.this.length() < BufferedRandomAccessFile.this.currBuf.filePos + (long)BufferedRandomAccessFile.this.currBuf.pos;
            }

            @Override
            public long skip(long n) throws IOException {
                BufferedRandomAccessFile.this.skipBytes(n);
                return n;
            }
        };
    }

    public Writer getWriter() {
        return new Writer(){

            @Override
            public void close() throws IOException {
                BufferedRandomAccessFile.this.close();
            }

            @Override
            public void flush() throws IOException {
                BufferedRandomAccessFile.this.flush();
            }

            @Override
            public void write(int ch) throws IOException {
                BufferedRandomAccessFile.this.writeChar(ch);
            }

            @Override
            public void write(char[] ch) throws IOException {
                this.write(ch, 0, ch.length);
            }

            @Override
            public void write(char[] ch, int pos, int len) throws IOException {
                for (int i = 0; i < len; ++i) {
                    BufferedRandomAccessFile.this.writeChar(ch[pos + i]);
                }
            }

            @Override
            public void write(String str) throws IOException {
                this.write(str, 0, str.length());
            }

            @Override
            public void write(String str, int pos, int len) throws IOException {
                for (int i = 0; i < len; ++i) {
                    BufferedRandomAccessFile.this.writeChar(str.charAt(pos + i));
                }
            }
        };
    }

    public FileDescriptor getFD() throws IOException {
        return this.delegate.getFD();
    }

    public long getFilePointer() {
        return this.currBuf.filePos + (long)this.currBuf.pos;
    }

    @Override
    public boolean readBoolean() throws IOException {
        return this.readByte() != 0;
    }

    @Override
    public int readUnsignedByte() throws IOException {
        int b = this.read();
        if (b < 0) {
            throw new EOFException();
        }
        return b & 0xFF;
    }

    @Override
    public byte readByte() throws IOException {
        int b = this.read();
        if (b < 0) {
            throw new EOFException();
        }
        return (byte)b;
    }

    @Override
    public short readShort() throws IOException {
        int ch2;
        int ch1 = this.read();
        if ((ch1 | (ch2 = this.read())) < 0) {
            throw new EOFException();
        }
        return (short)((ch1 << 8) + (ch2 << 0));
    }

    @Override
    public int readUnsignedShort() throws IOException {
        int ch2;
        int ch1 = this.read();
        if ((ch1 | (ch2 = this.read())) < 0) {
            throw new EOFException();
        }
        return (ch1 << 8) + (ch2 << 0);
    }

    @Override
    public char readChar() throws IOException {
        return (char)this.readUnsignedShort();
    }

    @Override
    public int readInt() throws IOException {
        int ch4;
        int ch3;
        int ch2;
        int ch1 = this.read();
        if ((ch1 | (ch2 = this.read()) | (ch3 = this.read()) | (ch4 = this.read())) < 0) {
            throw new EOFException();
        }
        return (ch1 << 24) + (ch2 << 16) + (ch3 << 8) + (ch4 << 0);
    }

    @Override
    public long readLong() throws IOException {
        return ((long)this.readInt() << 32) + ((long)this.readInt() & 0xFFFFFFFFL);
    }

    @Override
    public float readFloat() throws IOException {
        return Float.intBitsToFloat(this.readInt());
    }

    @Override
    public double readDouble() throws IOException {
        return Double.longBitsToDouble(this.readLong());
    }

    @Override
    public String readLine() throws IOException {
        StringBuffer input = new StringBuffer();
        int c = -1;
        boolean eol = false;
        block4: while (!eol) {
            c = this.read();
            switch (c) {
                case -1: 
                case 10: {
                    eol = true;
                    continue block4;
                }
                case 13: {
                    eol = true;
                    long cur = this.getFilePointer();
                    if (this.read() == 10) continue block4;
                    this.seek(cur);
                    continue block4;
                }
            }
            input.append((char)c);
        }
        if (c == -1 && input.length() == 0) {
            return null;
        }
        return input.toString();
    }

    @Override
    public String readUTF() throws IOException {
        return DataInputStream.readUTF(this);
    }

    @Override
    public void writeBoolean(boolean b) throws IOException {
        this.write(b ? 1 : 0);
    }

    @Override
    public void writeByte(int b) throws IOException {
        this.write(b);
    }

    @Override
    public void writeShort(int s) throws IOException {
        this.write(s >>> 8 & 0xFF);
        this.write(s >>> 0 & 0xFF);
    }

    @Override
    public void writeChar(int ch) throws IOException {
        this.writeShort(ch);
    }

    @Override
    public void writeInt(int i) throws IOException {
        this.write(i >>> 24 & 0xFF);
        this.write(i >>> 16 & 0xFF);
        this.write(i >>> 8 & 0xFF);
        this.write(i >>> 0 & 0xFF);
    }

    @Override
    public void writeLong(long l) throws IOException {
        this.write((int)(l >>> 56) & 0xFF);
        this.write((int)(l >>> 48) & 0xFF);
        this.write((int)(l >>> 40) & 0xFF);
        this.write((int)(l >>> 32) & 0xFF);
        this.write((int)(l >>> 24) & 0xFF);
        this.write((int)(l >>> 16) & 0xFF);
        this.write((int)(l >>> 8) & 0xFF);
        this.write((int)(l >>> 0) & 0xFF);
    }

    @Override
    public void writeFloat(float f) throws IOException {
        this.writeInt(Float.floatToIntBits(f));
    }

    @Override
    public void writeDouble(double f) throws IOException {
        this.writeLong(Double.doubleToLongBits(f));
    }

    @Override
    public void writeUTF(String str) throws IOException {
        char c;
        int i;
        int strlen = str.length();
        int utflen = 0;
        for (i = 0; i < strlen; ++i) {
            c = str.charAt(i);
            if (c >= '\u0001' && c <= '\u007f') {
                ++utflen;
                continue;
            }
            if (c > '\u07ff') {
                utflen += 3;
                continue;
            }
            utflen += 2;
        }
        if (utflen > 65535) {
            throw new UTFDataFormatException();
        }
        this.write(utflen >>> 8 & 0xFF);
        this.write(utflen >>> 0 & 0xFF);
        for (i = 0; i < strlen; ++i) {
            c = str.charAt(i);
            if (c >= '\u0001' && c <= '\u007f') {
                this.write(c);
                continue;
            }
            if (c > '\u07ff') {
                this.write(0xE0 | c >> 12 & 0xF);
                this.write(0x80 | c >> 6 & 0x3F);
                this.write(0x80 | c >> 0 & 0x3F);
                continue;
            }
            this.write(0xC0 | c >> 6 & 0x1F);
            this.write(0x80 | c >> 0 & 0x3F);
        }
    }

    @Override
    public void readFully(byte[] b) throws IOException {
        this.readFully(b, 0, b.length);
    }

    @Override
    public void readFully(byte[] b, int pos, int len) throws IOException {
        int count;
        for (int n = 0; n < len; n += count) {
            count = this.read(b, pos + n, len - n);
            if (count >= 0) continue;
            throw new EOFException();
        }
    }

    @Override
    public void writeBytes(String s) throws IOException {
        byte[] b = s.getBytes();
        this.write(b, 0, b.length);
    }

    @Override
    public void writeChars(String s) throws IOException {
        int clen = s.length();
        int blen = 2 * clen;
        byte[] b = new byte[blen];
        char[] c = new char[clen];
        s.getChars(0, clen, c, 0);
        int j = 0;
        for (int i = 0; i < clen; ++i) {
            b[j++] = (byte)(c[i] >>> 8);
            b[j++] = (byte)(c[i] >>> 0);
        }
        this.write(b, 0, blen);
    }

    public long length() throws IOException {
        long fileLen = this.delegate.length();
        if (this.currBuf.filePos + (long)this.currBuf.dataLen > fileLen) {
            return this.currBuf.filePos + (long)this.currBuf.dataLen;
        }
        return fileLen;
    }

    public int read() throws IOException {
        if (this.currBuf.pos < this.currBuf.dataLen) {
            return this.currBuf.bytes[this.currBuf.pos++];
        }
        this.syncBuffer(this.currBuf.filePos + (long)this.currBuf.pos);
        if (this.currBuf.dataLen == 0) {
            throw new EOFException();
        }
        return this.read();
    }

    public int read(byte[] b) throws IOException {
        return this.read(b, 0, b.length);
    }

    public int read(byte[] b, int pos, int len) throws IOException {
        if (this.currBuf.pos + len <= this.currBuf.dataLen) {
            System.arraycopy(this.currBuf.bytes, this.currBuf.pos, b, pos, len);
            this.currBuf.pos += len;
            return len;
        }
        this.syncBuffer(this.currBuf.filePos + (long)this.currBuf.pos);
        if (this.currBuf.dataLen < this.currBuf.bytes.length) {
            int readLen = Math.min(len, this.currBuf.dataLen);
            System.arraycopy(this.currBuf.bytes, this.currBuf.pos, b, pos, readLen);
            this.currBuf.pos += readLen;
            return readLen;
        }
        if (this.currBuf.dataLen <= len) {
            return this.read(b, pos, len);
        }
        this.delegate.seek(this.currBuf.filePos);
        int readLen = this.delegate.read(b, pos, len);
        if (len > this.currBuf.bytes.length) {
            this.currBuf.filePos += (long)(len - this.currBuf.bytes.length);
        }
        this.currBuf.dataLen = Math.min(readLen, this.currBuf.bytes.length);
        System.arraycopy(b, pos, this.currBuf.bytes, 0, this.currBuf.dataLen);
        return readLen;
    }

    public void seek(long pos) throws IOException {
        long newBufPos = pos - this.currBuf.filePos;
        if (newBufPos >= 0L && newBufPos < (long)this.currBuf.dataLen) {
            this.currBuf.pos = (int)newBufPos;
        } else {
            this.syncBuffer(pos);
        }
    }

    @Override
    public int skipBytes(int n) throws IOException {
        return (int)this.skipBytes((long)n);
    }

    public long skipBytes(long n) throws IOException {
        try {
            this.seek(this.currBuf.filePos + (long)this.currBuf.pos + n);
            return n;
        }
        catch (EOFException ex) {
            return -1L;
        }
    }

    @Override
    public void write(byte[] b) throws IOException {
        this.write(b, 0, b.length);
    }

    @Override
    public void write(byte[] b, int pos, int len) throws IOException {
        if (pos + len <= this.currBuf.bytes.length) {
            System.arraycopy(b, pos, this.currBuf.bytes, this.currBuf.pos, len);
            this.currBuf.pos += len;
            if (this.currBuf.pos > this.currBuf.dataLen) {
                this.currBuf.dataLen = this.currBuf.pos;
            }
        } else if (len <= this.currBuf.bytes.length) {
            this.syncBuffer(this.currBuf.filePos + (long)this.currBuf.pos);
            this.write(b, pos, len);
        } else {
            this.delegate.seek(this.currBuf.filePos + (long)this.currBuf.pos);
            this.delegate.write(b, pos, len);
            this.syncBuffer(this.currBuf.filePos + (long)this.currBuf.pos + (long)len);
        }
    }

    @Override
    public void write(int b) throws IOException {
        if (this.currBuf.pos < this.currBuf.bytes.length) {
            this.currBuf.bytes[this.currBuf.pos++] = (byte)b;
            this.currBuf.modified = true;
            if (this.currBuf.pos > this.currBuf.dataLen) {
                ++this.currBuf.dataLen;
            }
        } else {
            this.syncBuffer(this.currBuf.filePos + (long)this.currBuf.pos);
            this.write(b);
        }
    }

    public void flush() throws IOException {
        this.commitBuffer();
    }

    public void close() throws IOException {
        this.flush();
        this.delegate.close();
    }

    protected int syncBuffer(long new_FP) throws IOException {
        this.commitBuffer();
        this.delegate.seek(new_FP);
        this.currBuf.filePos = new_FP;
        this.fillBuffer();
        return this.currBuf.dataLen;
    }

    protected void fillBuffer() throws IOException {
        this.currBuf.dataLen = this.delegate.read(this.currBuf.bytes);
        this.currBuf.pos = 0;
        if (this.currBuf.dataLen < 0) {
            this.currBuf.dataLen = 0;
        }
    }

    protected void commitBuffer() throws IOException {
        if (this.currBuf.modified) {
            this.delegate.seek(this.currBuf.filePos);
            this.delegate.write(this.currBuf.bytes, 0, this.currBuf.dataLen);
            this.currBuf.modified = false;
        }
    }

    protected class FileBufferStruct {
        public byte[] bytes;
        public int pos;
        public int dataLen;
        public boolean modified;
        public long filePos;

        protected FileBufferStruct() {
        }
    }
}

