/*
 * Decompiled with CFR 0.152.
 */
package edu.northwestern.at.morphadorner.tools.tcp;

import edu.northwestern.at.morphadorner.tools.AdornedXMLWriter;
import edu.northwestern.at.morphadorner.tools.compareadornedfiles.MutableAdornedFile;
import edu.northwestern.at.utils.FileBatchProcessor;
import edu.northwestern.at.utils.FileNameUtils;
import edu.northwestern.at.utils.FileUtils;
import edu.northwestern.at.utils.MapUtils;
import edu.northwestern.at.utils.StringUtils;
import edu.northwestern.at.utils.xml.JDOMUtils;
import java.io.File;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.Namespace;

public class RemoveCruft {
    protected static Namespace teiNamespace = Namespace.getNamespace((String)"http://www.tei-c.org/ns/1.0");
    protected static Namespace teiNamespace2 = Namespace.getNamespace((String)"tei", (String)"http://www.tei-c.org/ns/1.0");
    protected static Pattern underlineCapPattern = Pattern.compile("^_\\p{Lu}");
    protected static final Matcher underlineCapMatcher = underlineCapPattern.matcher("");
    protected static Map<String, String> superscriptsMap;

    public static void main(String[] args) {
        try {
            RemoveCruft.removeCruft(args);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void removeCruft(String[] args) throws Exception {
        FileBatchProcessor processor = new FileBatchProcessor(){

            @Override
            public void processOneFile(String inputFileName) throws Exception {
                MutableAdornedFile mutableAdornedFile = new MutableAdornedFile(inputFileName);
                List<String> adornedWordIDs = mutableAdornedFile.getAdornedWordIDs();
                Document document = mutableAdornedFile.getDocument();
                for (int i = 0; i < adornedWordIDs.size(); ++i) {
                    Element adornedWord = mutableAdornedFile.getAdornedWord(adornedWordIDs.get(i));
                    String wordText = adornedWord.getText();
                    if (wordText.indexOf("\u017f") >= 0) {
                        wordText = StringUtils.replaceAll(wordText, "\u017f", "s");
                    }
                    if (wordText.indexOf("^") >= 0) {
                        wordText = StringUtils.replaceAll(wordText, "^", "");
                        JDOMUtils.setAttributeValue(adornedWord, "rend", "superscript");
                    }
                    if (superscriptsMap.containsKey(wordText)) {
                        wordText = superscriptsMap.get(wordText);
                    }
                    wordText = StringUtils.replaceAll(wordText, "\u0153", "oe");
                    wordText = StringUtils.replaceAll(wordText, "\u00e6", "ae");
                    wordText = StringUtils.replaceAll(wordText, "{", "");
                    wordText = StringUtils.replaceAll(wordText, "}", "");
                    underlineCapMatcher.reset(wordText);
                    if (underlineCapMatcher.find()) {
                        wordText = wordText.substring(1);
                        String rend = JDOMUtils.getAttributeValue(adornedWord, "rend", false);
                        if (rend == null || rend.trim().length() == 0) {
                            JDOMUtils.setAttributeValue(adornedWord, "rend", "initialcharacterdecorated");
                        }
                    }
                    adornedWord.setText(wordText);
                }
                String strippedFileName = FileNameUtils.stripPathName(inputFileName);
                strippedFileName = FileNameUtils.changeFileExtension(strippedFileName, "");
                String xmlOutputFileName = new File(this.outputDirectoryName, strippedFileName + ".xml").getAbsolutePath();
                FileUtils.createPathForFile(xmlOutputFileName);
                AdornedXMLWriter writer = new AdornedXMLWriter(document, xmlOutputFileName);
            }

            public Element createElement(String name) {
                Element element = new Element(name, teiNamespace);
                return element;
            }
        };
        processor.setOutputDirectoryName(args[0]);
        superscriptsMap = MapUtils.loadMap(args[1]);
        processor.setInputFileNames(args, 2);
        processor.run();
    }
}

