/*
 * Decompiled with CFR 0.152.
 */
package edu.northwestern.at.morphadorner.tools.tcp;

import edu.northwestern.at.utils.FileBatchProcessor;
import edu.northwestern.at.utils.FileUtils;
import edu.northwestern.at.utils.MapUtils;
import edu.northwestern.at.utils.StringUtils;
import edu.northwestern.at.utils.xml.ElementProcessor;
import edu.northwestern.at.utils.xml.JDOMUtils;
import edu.northwestern.at.utils.xml.jdom.ElementsFilter;
import java.io.File;
import java.util.Map;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.Namespace;
import org.jdom2.filter.Filter;
import org.jdom2.output.Format;

public class FixWordBreaks {
    public static Namespace teiNamespace = Namespace.getNamespace((String)"http://www.tei-c.org/ns/1.0");
    public static Map<String, String> fixedWordsMap;
    public static FileBatchProcessor processor;

    public static void main(String[] args) {
        try {
            FixWordBreaks.fixWordBreaks(args);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void fixWordBreaks(String[] args) throws Exception {
        processor = new FileBatchProcessor(){

            @Override
            public void processOneFile(String inputFileName) throws Exception {
                try {
                    System.out.println("Processing " + inputFileName);
                    String doc = FileUtils.readTextFile(inputFileName, "utf-8");
                    Document document = JDOMUtils.parseText(doc);
                    ElementsFilter filter = new ElementsFilter(new String[]{"w", "pc"});
                    JDOMUtils.applyElementFilter(document, (Filter<Element>)filter, new WProcessor());
                    String outputFileName = new File(this.outputDirectoryName, new File(inputFileName).getName()).getCanonicalPath();
                    Format format = Format.getRawFormat();
                    format.setOmitDeclaration(true);
                    FileUtils.createPathForFile(outputFileName);
                    JDOMUtils.save(document, outputFileName, format);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        };
        processor.setOutputDirectoryName(args[0]);
        fixedWordsMap = MapUtils.loadMap(args[1]);
        processor.setInputFileNames(args, 2);
        processor.run();
    }

    public static class WProcessor
    implements ElementProcessor {
        @Override
        public void processElement(Document document, Element w) {
            String wText = w.getText();
            String id = JDOMUtils.getAttributeValue(w, "xml:id", true);
            boolean hasHyphen = false;
            boolean bl = hasHyphen = wText.indexOf("\u2011") >= 0 || wText.indexOf("|") >= 0;
            if (hasHyphen) {
                if (wText.indexOf(" ") >= 0) {
                    processor.getPrintStream().println("   " + id + " contains blank, not handled.");
                } else {
                    wText = StringUtils.replaceAll(wText, "\u2011", "|");
                    wText = StringUtils.replaceAll(wText, "||", "|");
                    String fixedWText = "";
                    if (wText.equals("|")) {
                        fixedWText = "\u2011";
                    } else {
                        fixedWText = fixedWordsMap.get(wText);
                        if (fixedWText == null) {
                            fixedWText = StringUtils.replaceAll(wText, "|", "");
                        }
                    }
                    w.setText(fixedWText);
                }
            }
        }
    }
}

