/*
 * Decompiled with CFR 0.152.
 */
package edu.northwestern.at.morphadorner.tools.tcp;

import edu.northwestern.at.morphadorner.tools.AdornedXMLWriter;
import edu.northwestern.at.morphadorner.tools.compareadornedfiles.MutableAdornedFile;
import edu.northwestern.at.utils.FileBatchProcessor;
import edu.northwestern.at.utils.FileNameUtils;
import edu.northwestern.at.utils.FileUtils;
import edu.northwestern.at.utils.StringUtils;
import java.io.File;
import java.util.List;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.Namespace;

public class AddUnclear {
    protected static Namespace teiNamespace = Namespace.getNamespace((String)"http://www.tei-c.org/ns/1.0");
    protected static Namespace teiNamespace2 = Namespace.getNamespace((String)"tei", (String)"http://www.tei-c.org/ns/1.0");

    public static void main(String[] args) {
        try {
            AddUnclear.addUnclear(args);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void addUnclear(String[] args) throws Exception {
        FileBatchProcessor processor = new FileBatchProcessor(){

            @Override
            public void processOneFile(String inputFileName) throws Exception {
                MutableAdornedFile mutableAdornedFile = new MutableAdornedFile(inputFileName);
                List<String> adornedWordIDs = mutableAdornedFile.getAdornedWordIDs();
                Document document = mutableAdornedFile.getDocument();
                for (int i = 0; i < adornedWordIDs.size(); ++i) {
                    String type;
                    Element parentElement;
                    Element adornedWord = mutableAdornedFile.getAdornedWord(adornedWordIDs.get(i));
                    String wordText = adornedWord.getText();
                    if (wordText.indexOf("\u25cf") < 0 || (parentElement = adornedWord.getParentElement()).getName().equals("unclear") || (type = StringUtils.safeString(adornedWord.getAttributeValue("type"))).length() != 0) continue;
                    adornedWord.setAttribute("type", "unclear");
                }
                String strippedFileName = FileNameUtils.stripPathName(inputFileName);
                strippedFileName = FileNameUtils.changeFileExtension(strippedFileName, "");
                String xmlOutputFileName = new File(this.outputDirectoryName, strippedFileName + ".xml").getAbsolutePath();
                FileUtils.createPathForFile(xmlOutputFileName);
                AdornedXMLWriter writer = new AdornedXMLWriter(document, xmlOutputFileName);
            }

            public Element createElement(String name) {
                return new Element(name, teiNamespace);
            }
        };
        processor.setOutputDirectoryName(args[0]);
        processor.setInputFileNames(args, 1);
        processor.run();
    }
}

