/*
 * Decompiled with CFR 0.152.
 */
package edu.northwestern.at.morphadorner.tools.tagdiff;

import edu.northwestern.at.utils.CharUtils;
import edu.northwestern.at.utils.Compare;
import edu.northwestern.at.utils.Env;
import edu.northwestern.at.utils.Formatters;
import edu.northwestern.at.utils.MapFactory;
import edu.northwestern.at.utils.SortedArrayList;
import edu.northwestern.at.utils.StringUtils;
import edu.northwestern.at.utils.UnicodeReader;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.MalformedURLException;
import java.util.Map;

public class TagDiff {
    protected static Map<String, TagCount> incorrectTags = MapFactory.createNewMap();
    protected static Map<String, TagCount> tagCounts = MapFactory.createNewMap();

    public static void main(String[] args) {
        try {
            TagDiff.compareTaggedTexts(args[0], Integer.parseInt(args[1]), args[2], Integer.parseInt(args[3]));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected static void updateTagCount(Map<String, TagCount> map, String tag, int correct, int incorrect, int comparisonType) {
        TagCount tagCount = map.get(tag);
        if (tagCount == null) {
            tagCount = new TagCount(tag);
            tagCount.setComparisonType(comparisonType);
            map.put(tag, tagCount);
        }
        tagCount.update(correct, incorrect);
    }

    protected static void compareTaggedTexts(String taggedFile1, int tagColFile1, String taggedFile2, int tagColFile2) throws MalformedURLException, IOException {
        BufferedReader tagged1Reader = new BufferedReader(new UnicodeReader(new FileInputStream(taggedFile1), "utf-8"));
        BufferedReader tagged2Reader = new BufferedReader(new UnicodeReader(new FileInputStream(taggedFile2), "utf-8"));
        BufferedOutputStream bufferedStream = new BufferedOutputStream(System.out);
        OutputStreamWriter outWriter = new OutputStreamWriter((OutputStream)bufferedStream, "utf-8");
        String line1 = tagged1Reader.readLine();
        String line2 = tagged2Reader.readLine();
        int lineCount1 = 1;
        int lineCount2 = 1;
        int matches = 0;
        int mismatches = 0;
        while (line1 != null && line2 != null) {
            boolean emptyline2;
            line1 = line1.trim();
            line2 = line2.trim();
            boolean emptyline1 = line1.length() == 0;
            boolean bl = emptyline2 = line2.length() == 0;
            if (!emptyline1 && !emptyline2) {
                String[] tokens2;
                String[] tokens1 = line1.split("\t");
                if (!tokens1[0].equals((tokens2 = line2.split("\t"))[0])) {
                    System.err.println("Mismatched words " + tokens1[0] + " and " + tokens2[0] + " at line " + lineCount1 + " in first tagged file and line " + lineCount2 + " in second tagged file.");
                    System.err.flush();
                    System.exit(1);
                }
                if (tokens1[tagColFile1].equalsIgnoreCase(tokens2[tagColFile2]) || CharUtils.isPunctuation(tokens1[0])) {
                    ++matches;
                    TagDiff.updateTagCount(tagCounts, tokens1[tagColFile1], 1, 0, 3);
                } else {
                    ++mismatches;
                    TagDiff.updateTagCount(tagCounts, tokens1[tagColFile1], 0, 1, 3);
                    String badTags = tokens2[tagColFile2] + " instead of " + tokens1[tagColFile1];
                    TagDiff.updateTagCount(incorrectTags, badTags, 0, 1, 2);
                }
            }
            if (!emptyline2) {
                line1 = tagged1Reader.readLine();
                ++lineCount1;
            }
            if (emptyline1) continue;
            line2 = tagged2Reader.readLine();
            ++lineCount2;
        }
        tagged1Reader.close();
        tagged2Reader.close();
        SortedArrayList<TagCount> incorrectTagCounts = new SortedArrayList<TagCount>();
        for (String tag : incorrectTags.keySet()) {
            TagCount tagCount = incorrectTags.get(tag);
            incorrectTagCounts.add(tagCount);
        }
        int wordCount = matches + mismatches;
        outWriter.write(Env.LINE_SEPARATOR);
        outWriter.write(Env.LINE_SEPARATOR);
        outWriter.write("Counts of tagging errors.");
        outWriter.write(Env.LINE_SEPARATOR);
        outWriter.write(Env.LINE_SEPARATOR);
        outWriter.write("            Pct.");
        outWriter.write(Env.LINE_SEPARATOR);
        outWriter.write("     Count  Error   Tags confused");
        outWriter.write(Env.LINE_SEPARATOR);
        outWriter.write(Env.LINE_SEPARATOR);
        for (int i = 0; i < incorrectTagCounts.size(); ++i) {
            TagCount tagCount = (TagCount)incorrectTagCounts.get(i);
            if (tagCount.incorrect == 0) continue;
            String s = StringUtils.lpad(Formatters.formatIntegerWithCommas(tagCount.incorrect), 10);
            outWriter.write(s);
            double pctOfError = (double)tagCount.incorrect / (double)mismatches;
            pctOfError = (double)Math.round(pctOfError * 1000.0) / 10.0;
            s = StringUtils.lpad(Formatters.formatDouble(pctOfError, 1), 5);
            outWriter.write(s);
            outWriter.write("%    ");
            outWriter.write(tagCount.tag);
            outWriter.write(Env.LINE_SEPARATOR);
        }
        double pctMatched = (double)matches / (double)wordCount;
        pctMatched = (double)Math.round(pctMatched * 1000.0) / 10.0;
        double pctNotMatched = (double)mismatches / (double)wordCount;
        pctNotMatched = (double)Math.round(pctNotMatched * 1000.0) / 10.0;
        outWriter.write(Env.LINE_SEPARATOR);
        outWriter.write("Total number of words    : " + wordCount);
        outWriter.write(Env.LINE_SEPARATOR);
        outWriter.write("Correctly tagged words   : " + matches + " (" + pctMatched + "%)");
        outWriter.write(Env.LINE_SEPARATOR);
        outWriter.write("Incorrectly tagged words : " + mismatches + " (" + pctNotMatched + "%)");
        outWriter.write(Env.LINE_SEPARATOR);
        outWriter.flush();
        outWriter.close();
    }

    protected TagDiff() {
    }

    static class TagCount
    implements Comparable {
        public String tag;
        public int correct;
        public int incorrect;
        public int comparisonType;

        public TagCount(String tag) {
            this.tag = tag;
            this.correct = 0;
            this.incorrect = 0;
            this.comparisonType = 0;
        }

        public TagCount(String tag, int correct, int incorrect) {
            this.tag = tag;
            this.correct = correct;
            this.incorrect = incorrect;
            this.comparisonType = 0;
        }

        public void setComparisonType(int comparisonType) {
            this.comparisonType = Math.min(Math.max(comparisonType, 0), 2);
        }

        public void update(int correct, int incorrect) {
            this.correct += correct;
            this.incorrect += incorrect;
        }

        public double percentageIncorrect() {
            return (double)this.incorrect / (double)(this.correct + this.incorrect);
        }

        public String toString() {
            return this.tag + " " + this.correct + " " + this.incorrect;
        }

        public int compareTo(Object object) {
            int result = Integer.MIN_VALUE;
            if (object != null && object instanceof TagCount) {
                TagCount otherTagCount = (TagCount)object;
                switch (this.comparisonType) {
                    case 1: {
                        result = -Compare.compare(this.correct, otherTagCount.correct);
                        if (result != 0) break;
                        result = Compare.compare(this.tag, otherTagCount.tag);
                        break;
                    }
                    case 2: {
                        result = -Compare.compare(this.incorrect, otherTagCount.incorrect);
                        if (result != 0) break;
                        result = Compare.compare(this.tag, otherTagCount.tag);
                        break;
                    }
                    case 3: {
                        result = -Compare.compare(this.percentageIncorrect(), otherTagCount.percentageIncorrect());
                        if (result != 0) break;
                        result = Compare.compare(this.tag, otherTagCount.tag);
                        break;
                    }
                    default: {
                        result = Compare.compare(this.tag, otherTagCount.tag);
                    }
                }
            }
            return result;
        }
    }
}

