/*
 * Decompiled with CFR 0.152.
 */
package edu.northwestern.at.morphadorner.tools.sampletextfile;

import edu.northwestern.at.morphadorner.tools.sampletextfile.SampleTextFile;
import edu.northwestern.at.utils.UnicodeReader;
import edu.northwestern.at.utils.math.randomnumbers.RandomVariable;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;

public class ExactlySampleTextFile
extends SampleTextFile {
    protected int totalCount = 0;
    protected int sampleCount = 0;

    public static void main(String[] args) {
        try {
            int sampleCount;
            if (args.length < 3) {
                System.err.println("Too few arguments.");
                ExactlySampleTextFile.help();
                System.exit(1);
            }
            if ((sampleCount = Integer.parseInt(args[2])) < 0) {
                System.err.println("Bad sample count -- must be an integer greater than zero.");
                System.exit(1);
            }
            new ExactlySampleTextFile(args[0], args[1], sampleCount).sample();
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(1);
        }
    }

    public static void help() {
        System.out.println();
        System.out.println("java edu.northwestern.at.morphadorner.tools.sampletextfile.ExactlySampleTextFile input.txt output.txt samplecount");
        System.out.println();
        System.out.println("   input.txt -- input text file to be sampled.");
        System.out.println("   output.txt -- output text file.");
        System.out.println("   samplecount -- count of lines to sample from input.");
    }

    public ExactlySampleTextFile(String inputFileName, String outputFileName, int sample) {
        super(inputFileName, outputFileName, (double)sample);
    }

    @Override
    protected void setupSampling() {
        this.sampleCount = (int)this.sample;
    }

    @Override
    public void sample() {
        try {
            this.totalCount = 0;
            UnicodeReader streamReader = new UnicodeReader(new FileInputStream(new File(this.inputFileName)), "utf-8");
            BufferedReader in = new BufferedReader(streamReader);
            String inputLine = in.readLine();
            while (inputLine != null) {
                ++this.totalCount;
                inputLine = in.readLine();
            }
            in.close();
        }
        catch (Exception e) {
            e.printStackTrace();
            System.out.println("   *** Failed");
        }
    }

    @Override
    protected boolean lineSelected(String inputLine) {
        boolean result;
        double samp = (double)this.sampleCount / (double)this.totalCount;
        boolean bl = result = RandomVariable.rand() < samp;
        if (result) {
            --this.sampleCount;
        }
        --this.totalCount;
        return result;
    }

    @Override
    public boolean samplingDone() {
        return this.sampleCount <= 0;
    }
}

