/*
 * Decompiled with CFR 0.152.
 */
package edu.northwestern.at.morphadorner.tools.relemmatize;

import edu.northwestern.at.morphadorner.corpuslinguistics.lemmatizer.DefaultLemmatizer;
import edu.northwestern.at.morphadorner.corpuslinguistics.lexicon.DefaultLexicon;
import edu.northwestern.at.morphadorner.corpuslinguistics.namestandardizer.NoopNameStandardizer;
import edu.northwestern.at.morphadorner.corpuslinguistics.spellingmapper.USToBritishSpellingMapper;
import edu.northwestern.at.morphadorner.corpuslinguistics.spellingstandardizer.ExtendedSimpleSpellingStandardizer;
import edu.northwestern.at.morphadorner.tools.FilterAdornedFile;
import edu.northwestern.at.morphadorner.tools.relemmatize.RelemmatizeFilter;
import edu.northwestern.at.utils.FileNameUtils;
import edu.northwestern.at.utils.FileUtils;
import edu.northwestern.at.utils.Formatters;
import edu.northwestern.at.utils.StringUtils;
import java.io.File;
import org.xml.sax.helpers.XMLReaderFactory;

public class Relemmatize {
    protected static final int INITPARAMS = 5;
    protected static int docsToProcess = 0;
    protected static int currentDocNumber = 0;
    protected static String outputDirectory;
    protected static RelemmatizeFilter relemmatizeFilter;

    public static void main(String[] args) {
        try {
            if (!Relemmatize.initialize(args)) {
                System.exit(1);
            }
            long startTime = System.currentTimeMillis();
            int filesProcessed = Relemmatize.processFiles(args);
            long processingTime = (System.currentTimeMillis() - startTime + 999L) / 1000L;
            Relemmatize.terminate(filesProcessed, processingTime);
        }
        catch (Exception e) {
            System.out.println(e.getMessage());
        }
    }

    protected static boolean initialize(String[] args) throws Exception {
        if (args.length < 6) {
            System.err.println("Not enough parameters.");
            return false;
        }
        DefaultLemmatizer lemmatizer = new DefaultLemmatizer();
        DefaultLexicon wordLexicon = new DefaultLexicon();
        wordLexicon.loadLexicon(new File(args[0]).toURI().toURL(), "utf-8");
        NoopNameStandardizer nameStandardizer = new NoopNameStandardizer();
        USToBritishSpellingMapper spellingMapper = new USToBritishSpellingMapper();
        ExtendedSimpleSpellingStandardizer standardizer = new ExtendedSimpleSpellingStandardizer();
        standardizer.loadAlternativeSpellings(new File(args[1]).toURI().toURL(), "utf-8", "\t");
        standardizer.loadAlternativeSpellingsByWordClass(new File(args[2]).toURI().toURL(), "utf-8");
        standardizer.loadStandardSpellings(new File(args[3]).toURI().toURL(), "utf-8");
        lemmatizer.setDictionary(standardizer.getStandardSpellings());
        lemmatizer.setLexicon(wordLexicon);
        outputDirectory = args[4];
        relemmatizeFilter = new RelemmatizeFilter(XMLReaderFactory.createXMLReader(), wordLexicon, lemmatizer, nameStandardizer, standardizer, spellingMapper);
        return true;
    }

    protected static void processOneFile(String xmlInputFileName) {
        try {
            String xmlOutputFileName = new File(outputDirectory, FileNameUtils.stripPathName(xmlInputFileName)).getAbsolutePath();
            FileUtils.createPathForFile(xmlOutputFileName);
            new FilterAdornedFile(xmlInputFileName, xmlOutputFileName, relemmatizeFilter);
            System.out.println("File " + xmlInputFileName + " contains " + Formatters.formatIntegerWithCommas(relemmatizeFilter.getWordsProcessed()) + " word elements.");
            System.out.println(Formatters.formatIntegerWithCommas(relemmatizeFilter.getStandardChanged()) + " standard spellings updated.");
            System.out.println(Formatters.formatIntegerWithCommas(relemmatizeFilter.getLemmataChanged()) + " lemmata updated.");
        }
        catch (Exception e) {
            System.out.println(xmlInputFileName + " failed");
            System.out.println(e.getMessage());
        }
    }

    protected static int processFiles(String[] args) {
        boolean result = false;
        String[] wildCards = new String[args.length - 5];
        for (int i = 5; i < args.length; ++i) {
            wildCards[i - 5] = args[i];
        }
        String[] fileNames = FileNameUtils.expandFileNameWildcards(wildCards);
        docsToProcess = fileNames.length;
        for (int i = 0; i < fileNames.length; ++i) {
            Relemmatize.processOneFile(fileNames[i]);
        }
        return fileNames.length;
    }

    protected static void terminate(int filesProcessed, long processingTime) {
        System.out.println("Processed " + Formatters.formatIntegerWithCommas(filesProcessed) + StringUtils.pluralize(filesProcessed, " file in ", " files in ") + Formatters.formatLongWithCommas(processingTime) + StringUtils.pluralize(processingTime, " second.", " seconds."));
    }
}

