/*
 * Decompiled with CFR 0.152.
 */
package edu.northwestern.at.morphadorner.tools.punktabbreviationdetector;

import edu.northwestern.at.morphadorner.tools.punktabbreviationdetector.PunktTokenType;

public class PunktToken {
    protected String tokenText;
    protected int startPosition;
    protected PunktTokenType tokenType;

    public PunktToken(String tokenText, int start, PunktTokenType tokenType) {
        this.tokenText = tokenText;
        this.startPosition = start;
        this.tokenType = tokenType;
    }

    public PunktToken(String tokenText, PunktTokenType tokenType) {
        this.tokenText = tokenText;
        this.startPosition = 0;
        this.tokenType = tokenType;
    }

    public String getTokenText() {
        return this.tokenText;
    }

    public PunktTokenType getTokenType() {
        return this.tokenType;
    }

    public int getStartPosition() {
        return this.startPosition;
    }

    public int getEndPosition() {
        return this.startPosition + this.tokenText.length();
    }

    public String getSingleCharCode() {
        String result = null;
        if (this.tokenText.length() == 1) {
            result = "u" + Integer.toHexString(this.tokenText.charAt(0));
        }
        return result;
    }

    public int getLength() {
        return this.tokenText.length();
    }

    public String toString() {
        return this.tokenText;
    }
}

