/*
 * Decompiled with CFR 0.152.
 */
package edu.northwestern.at.morphadorner.tools.lgparser;

import edu.northwestern.at.utils.StringUtils;
import java.util.StringTokenizer;
import net.sf.jlinkgrammar.Dictionary;
import net.sf.jlinkgrammar.Linkage;
import net.sf.jlinkgrammar.ParseOptions;
import net.sf.jlinkgrammar.Sentence;

public class LGParser {
    protected static Dictionary dictionary;
    protected ParseOptions parseOptions = new ParseOptions();
    protected Sentence sentence;
    protected static String defaultDataDirectory;

    public LGParser() {
        this(defaultDataDirectory, 100, 1);
    }

    public LGParser(String dataDirectory) {
        this(dataDirectory, 100, 1);
    }

    public LGParser(int maxLinkage, int maxParseTime) {
        this(defaultDataDirectory, maxLinkage, maxParseTime);
    }

    public LGParser(String dataDirectory, int maxLinkage, int maxParseTime) {
        this.parseOptions.parse_options_set_short_length(10);
        this.parseOptions.parse_options_set_max_null_count(10);
        this.parseOptions.parse_options_set_linkage_limit(maxLinkage);
        if (dictionary == null) {
            try {
                dictionary = new Dictionary(this.parseOptions, dataDirectory + "/4.0.dict", "4.0.knowledge", "4.0.constituent-knowledge", "4.0.affix");
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public Linkage getLinkage(int index) {
        return new Linkage(index, this.sentence, this.parseOptions);
    }

    public Sentence parse(String s) {
        this.sentence = new Sentence(s, dictionary, this.parseOptions);
        this.sentence.sentence_parse(this.parseOptions);
        return this.sentence;
    }

    public static void main(String[] args) {
        if (args.length > 1) {
            String dataDirectory = args[0];
            LGParser parser = new LGParser(dataDirectory);
            String textToParse = args[1];
            Sentence sentence = parser.parse(textToParse);
            if (sentence.sentence_num_linkages_found() < 1) {
                System.out.println("No linkage was found.");
            } else {
                Linkage link = parser.getLinkage(0);
                System.out.println(link.linkage_print_diagram());
                System.out.println(LGParser.fixOutput(link.linkage_print_links_and_domains()));
                System.out.println(link.linkage_print_constituent_tree(1));
            }
        }
    }

    protected static String fixOutput(String s) {
        int i;
        int[] colWidths = new int[6];
        for (int i2 = 0; i2 < colWidths.length; ++i2) {
            colWidths[i2] = 0;
        }
        String[] lines = s.split("\n");
        for (i = 0; i < lines.length; ++i) {
            String line = lines[i];
            if (line.equals("\n")) continue;
            StringTokenizer tokenizer = new StringTokenizer(line);
            int j = 0;
            if (line.charAt(0) == ' ') {
                ++j;
            }
            while (tokenizer.hasMoreTokens()) {
                String token = tokenizer.nextToken().trim();
                colWidths[j] = Math.max(colWidths[j], token.length());
                ++j;
            }
        }
        i = 0;
        while (i < colWidths.length) {
            int n = i++;
            colWidths[n] = colWidths[n] + 2;
        }
        StringBuffer sb = new StringBuffer();
        for (int i3 = 0; i3 < lines.length; ++i3) {
            String line = lines[i3];
            if (line.equals("\n")) continue;
            StringTokenizer tokenizer = new StringTokenizer(line);
            int j = 0;
            if (line.charAt(0) == ' ') {
                sb.append(StringUtils.dupl(" ", colWidths[j++]));
            }
            while (tokenizer.hasMoreTokens()) {
                String token = tokenizer.nextToken();
                sb.append(StringUtils.rpad(token, colWidths[j++]));
            }
            sb.append("\n");
        }
        return sb.toString();
    }

    static {
        defaultDataDirectory = "data/lgparser";
    }
}

