/*
 * Decompiled with CFR 0.152.
 */
package edu.northwestern.at.morphadorner.tools.fixquotes;

import edu.northwestern.at.morphadorner.corpuslinguistics.tokenizer.DefaultWordTokenizer;
import edu.northwestern.at.utils.FileUtils;
import edu.northwestern.at.utils.SingleTagTaggedStrings;
import edu.northwestern.at.utils.StringUtils;
import edu.northwestern.at.utils.TaggedStrings;
import edu.northwestern.at.utils.TextFile;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class FixQuotes {
    protected static final String lsquo = "&lsquo;";
    protected static final String ldquo = "&ldquo;";
    protected static final String rsquo = "&rsquo;";
    protected static final String rdquo = "&rdquo;";
    protected static final String apos = "&apos;";
    protected static final String sq = "\ue060";
    protected static final String dq = "\ue061";

    public static void main(String[] args) {
        String s = "";
        try {
            s = FileUtils.readTextFile(args[0], "utf-8");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        TaggedStrings contractions = FixQuotes.loadContractions("resources/contractions.txt");
        Pattern contractionsPattern = FixQuotes.buildContractionsPattern(contractions);
        Matcher contractionsMatcher = contractionsPattern.matcher("");
        s = FixQuotes.repairQuotes(s, contractionsMatcher, contractions);
        try {
            FileUtils.writeTextFile(args[1], false, s, "utf-8");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static String repairQuotes(String s, Matcher contractionsMatcher, TaggedStrings contractions) {
        String result = s;
        result = result.replaceAll("``", ldquo);
        result = result.replaceAll("`", lsquo);
        result = result.replaceAll("(\\s)\"(?=\\s)", "$1\ue061");
        result = result.replaceAll("(\\s)'(?=\\s)", "$1\ue060");
        if (contractionsMatcher != null) {
            contractionsMatcher.reset(result);
            StringBuffer sb = new StringBuffer();
            while (contractionsMatcher.find()) {
                String group1 = contractionsMatcher.group(1);
                String group2 = contractionsMatcher.group(2);
                if (contractions.containsString(group2)) {
                    group2 = group2.replaceAll("'", apos);
                }
                String s2 = group1 + group2;
                contractionsMatcher.appendReplacement(sb, s2);
            }
            contractionsMatcher.appendTail(sb);
            result = sb.toString();
        }
        result = result.replaceAll("^'(?=\\p{Punct}\\B)", lsquo);
        result = result.replaceAll("^\"(?=\\p{Punct}\\B)", ldquo);
        result = result.replaceAll("\"'(?=\\w)", "&ldquo;&lsquo;");
        result = result.replaceAll("\"'(?=\\W)", "&rdquo;&rsquo;");
        result = result.replaceAll("'\"(?=\\w)", "&lsquo;&ldquo;");
        result = result.replaceAll("'\"(?=\\W)", "&rsquo;&rdquo;");
        result = result.replaceAll("'(?=\\d{2}s)", apos);
        String closeClass = "[^\\ \\t\\r\\n\\[\\{\\(\\-\u2013\u2014]";
        result = result.replaceAll("(\\s|-{1,}|\u2013{1,}|\u2014{1,})'(?=\\w)", "$1&lsquo;");
        result = result.replaceAll("(\\w)?'(\\w)", "$1&apos;$2");
        result = result.replaceAll("(" + closeClass + ")?'", "$1&rsquo;");
        result = result.replaceAll("'(?=\\s|s\\b|S\\b)", rsquo);
        result = StringUtils.replaceAll(result, "'", lsquo);
        result = result.replaceAll("(\\s|-{1,}|\u2013{1,}|\u2014{1,})\"(?=\\w)", "$1&ldquo;");
        result = result.replaceAll("(" + closeClass + ")?\"", "$1&rdquo;");
        result = result.replaceAll("\"(?=\\s)", rdquo);
        result = StringUtils.replaceAll(result, "\"", ldquo);
        int iPos = result.indexOf(sq);
        boolean even = false;
        while (iPos >= 0) {
            result = result.substring(0, iPos) + (even ? rsquo : lsquo) + result.substring(iPos + 1);
            even = !even;
            iPos = result.indexOf(sq);
        }
        iPos = result.indexOf(dq);
        even = false;
        while (iPos >= 0) {
            result = result.substring(0, iPos) + (even ? rdquo : ldquo) + result.substring(iPos + 1);
            even = !even;
            iPos = result.indexOf(dq);
        }
        return result;
    }

    public static TaggedStrings loadContractions(String contractionsURL) {
        TextFile contractionsFile = new TextFile(DefaultWordTokenizer.class.getResourceAsStream(contractionsURL), "utf-8");
        SingleTagTaggedStrings contractions = new SingleTagTaggedStrings(contractionsFile.toArray(), "1");
        return contractions;
    }

    public static Pattern buildContractionsPattern(TaggedStrings contractions) {
        return Pattern.compile("(\\W)('\\w*|\\w*')(?=\\W)");
    }

    protected FixQuotes() {
    }
}

