/*
 * Decompiled with CFR 0.152.
 */
package edu.northwestern.at.morphadorner.tools.countaffixes;

import edu.northwestern.at.morphadorner.tools.AdornedXMLReader;
import edu.northwestern.at.morphadorner.tools.ExtendedAdornedWord;
import edu.northwestern.at.utils.CountMapUtils;
import edu.northwestern.at.utils.MapFactory;
import edu.northwestern.at.utils.MapUtils;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

public class CountAffixes {
    public static void main(String[] args) {
        if (args.length >= 3) {
            new CountAffixes(args);
        } else {
            CountAffixes.displayUsage();
            System.exit(1);
        }
    }

    public static void displayUsage() {
        System.out.println("Usage: ");
        System.out.println("");
        System.out.println("   java edu.northwestern.at.morphadorner.tool.countaffixes.CountAffixes input.xml prefixes.tab suffixes.tab");
        System.out.println("");
        System.out.println("      input.xml -- input XML file");
        System.out.println("      prefixes.tab -- output tab-separated prefixes and counts file.");
        System.out.println("      suiffixes.tab -- output tab-separated suffixes and counts file.");
    }

    public CountAffixes(String[] args) {
        String xmlInputFileName = args[0];
        Map wordsMap = MapFactory.createNewMap();
        Map prefixesMap = MapFactory.createNewMap();
        Map suffixesMap = MapFactory.createNewMap();
        try {
            AdornedXMLReader xmlReader = new AdornedXMLReader(xmlInputFileName);
            List<String> idList = xmlReader.getAdornedWordIDs();
            for (int wordOrd = 0; wordOrd < idList.size(); ++wordOrd) {
                String id = idList.get(wordOrd);
                ExtendedAdornedWord w = xmlReader.getExtendedAdornedWord(id);
                if (!w.isFirstPart()) continue;
                String spelling = w.getSpelling().toLowerCase();
                CountMapUtils.updateWordCountMap(spelling, 1, wordsMap);
            }
            for (String spelling : wordsMap.keySet()) {
                int l = spelling.length();
                for (int i = 0; i < l; ++i) {
                    CountMapUtils.updateWordCountMap(spelling.substring(0, i + 1), 1, prefixesMap);
                    CountMapUtils.updateWordCountMap(spelling.substring(i, l), 1, suffixesMap);
                }
            }
            MapUtils.saveMap(new TreeMap(prefixesMap), args[1], "\t", "", "utf-8");
            MapUtils.saveMap(new TreeMap(suffixesMap), args[2], "\t", "", "utf-8");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

