/*
 * Decompiled with CFR 0.152.
 */
package edu.northwestern.at.morphadorner.tools.compareadornedfiles;

import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.io.HierarchicalStreamDriver;
import com.thoughtworks.xstream.io.xml.DomDriver;
import edu.northwestern.at.morphadorner.tools.AdornedXMLWriter;
import edu.northwestern.at.morphadorner.tools.compareadornedfiles.MutableAdornedFile;
import edu.northwestern.at.morphadorner.tools.compareadornedfiles.WordChange;
import edu.northwestern.at.morphadorner.tools.compareadornedfiles.WordChangeLog;
import edu.northwestern.at.utils.FileUtils;
import edu.northwestern.at.utils.Formatters;
import java.io.BufferedOutputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.List;

public class UpdateAdornedFile {
    public UpdateAdornedFile(boolean revert, String srcAdornedFileName, String changeLogFileName, String destAdornedFileName, PrintStream printStream) throws Exception {
        long startTime = System.currentTimeMillis();
        MutableAdornedFile mutableAdornedFile = new MutableAdornedFile(srcAdornedFileName);
        XStream xstream = new XStream((HierarchicalStreamDriver)new DomDriver());
        xstream.alias("change", WordChange.class);
        xstream.alias("ChangeLog", WordChangeLog.class);
        String changeLogText = FileUtils.readTextFile(changeLogFileName, "utf-8");
        WordChangeLog changeLog = (WordChangeLog)xstream.fromXML(changeLogText);
        long endTime = (System.currentTimeMillis() - startTime + 999L) / 1000L;
        List<String> wordIDs = mutableAdornedFile.getAdornedWordIDs();
        if (printStream != null) {
            printStream.println("Read " + Formatters.formatIntegerWithCommas(wordIDs.size()) + " words from " + srcAdornedFileName + ".");
            printStream.println("Read " + Formatters.formatIntegerWithCommas(changeLog.getNumberOfChanges()) + " changes from " + changeLogFileName + ".");
        }
        startTime = System.currentTimeMillis();
        if (revert) {
            mutableAdornedFile.revertChanges(changeLog.getChanges());
        } else {
            mutableAdornedFile.applyChanges(changeLog.getChanges());
        }
        endTime = (System.currentTimeMillis() - startTime + 999L) / 1000L;
        if (printStream != null) {
            printStream.println("Changes applied in " + Formatters.formatLongWithCommas(endTime) + (endTime == 1L ? " second." : "seconds."));
        }
        new AdornedXMLWriter(mutableAdornedFile.getDocument(), destAdornedFileName);
    }

    public static void main(String[] args) {
        try {
            PrintStream printStream = new PrintStream((OutputStream)new BufferedOutputStream(System.out), true, "utf-8");
            if (args.length < 4) {
                UpdateAdornedFile.displayHelp(printStream);
                System.exit(1);
            }
            String operation = args[0].toLowerCase();
            boolean revert = false;
            if (operation.equals("revert")) {
                revert = true;
            } else if (!operation.equals("update")) {
                printStream.println("Operation must be either \"update\" or \"revert\".");
                System.exit(1);
            }
            new UpdateAdornedFile(revert, args[1], args[2], args[3], printStream);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void displayHelp(PrintStream printStream) {
        if (printStream == null) {
            return;
        }
        printStream.println("java edu.northwestern.at.morphadorner.tools.compareadornedfiles.UpdateAdornedFile operation srcadorned.xml changelog.xml destadorned.xml");
        printStream.println();
        printStream.println("operation -- Update operation, either \"update\" to apply 4pdates");
        printStream.println("in changelog.xml to srcadorned.xml to produce destadorned.xml,");
        printStream.println("or \"revert\" to undo updates in changelog.xml to srcadorned.xml");
        printStream.println(" to produce destadorned.xml .");
        printStream.println();
        printStream.println("srcadorned.xml -- Source adorned file.");
        printStream.println();
        printStream.println("changelog.xml -- Word differences between two adorned files.");
        printStream.println();
        printStream.println("destadorned.xml -- Destination adorned file.");
    }
}

