/*
 * Decompiled with CFR 0.152.
 */
package edu.northwestern.at.morphadorner.tools.compareadornedfiles;

import edu.northwestern.at.morphadorner.tools.compareadornedfiles.CompareAdornedFiles;
import edu.northwestern.at.utils.FileNameUtils;
import edu.northwestern.at.utils.Formatters;
import edu.northwestern.at.utils.StringUtils;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.OutputStream;
import java.io.PrintStream;

public class GetTokenChanges {
    protected static String oldAdornedFilesDirectory;
    protected static String newAdornedFilesDirectory;
    protected static String changeFilesDirectory;

    public static void main(String[] args) {
        try {
            GetTokenChanges.getTokenChanges(args);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void getTokenChanges(String[] args) throws Exception {
        PrintStream printStream = new PrintStream((OutputStream)new BufferedOutputStream(System.out), true, "utf-8");
        if (args.length < 3) {
            printStream.println("Not enough parameters.");
            System.exit(1);
        }
        oldAdornedFilesDirectory = args[0];
        newAdornedFilesDirectory = args[1];
        changeFilesDirectory = args[2];
        String wildcard = oldAdornedFilesDirectory + File.separator + "*.xml";
        String[] oldAdornedFileNames = FileNameUtils.expandFileNameWildcards(new String[]{wildcard});
        int nOld = oldAdornedFileNames.length;
        printStream.println("There are " + Formatters.formatIntegerWithCommas(nOld) + StringUtils.pluralize(nOld, " file ", " files ") + " to process.");
        for (int i = 0; i < oldAdornedFileNames.length; ++i) {
            String oldAdornedFileName = oldAdornedFileNames[i];
            String strippedFileName = FileNameUtils.stripPathName(oldAdornedFileName);
            String newAdornedFileName = new File(newAdornedFilesDirectory, strippedFileName).getCanonicalPath();
            String changeFileName = new File(changeFilesDirectory, "changes-" + strippedFileName).getCanonicalPath();
            new CompareAdornedFiles(oldAdornedFileName, newAdornedFileName, changeFileName, printStream);
            System.gc();
        }
        printStream.println("Finished processing.");
    }
}

