/*
 * Decompiled with CFR 0.152.
 */
package edu.northwestern.at.morphadorner.tools.compareadornedfiles;

import edu.northwestern.at.morphadorner.tools.compareadornedfiles.AdornedWordData;
import edu.northwestern.at.utils.ListFactory;
import edu.northwestern.at.utils.MapFactory;
import edu.northwestern.at.utils.SetFactory;
import edu.northwestern.at.utils.xml.JDOMUtils;
import edu.northwestern.at.utils.xml.jdom.ElementsFilter;
import java.io.File;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jdom2.Attribute;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.filter.Filter;
import org.jdom2.util.IteratorIterable;

public class AdornedWordsLoader {
    protected Map<String, AdornedWordData> adornedWordDataMap = MapFactory.createNewLinkedMap(10000);
    protected List<String> wordIDs = ListFactory.createNewList(10000);
    protected Set<String> wordTagsSet = SetFactory.createNewSet();
    protected Document adornedXMLDocument = null;

    public AdornedWordsLoader(String adornedFileName, String[] wordTags) throws Exception {
        this.wordTagsSet.addAll(Arrays.asList(wordTags));
        this.adornedXMLDocument = JDOMUtils.parse(new File(adornedFileName));
        ElementsFilter filter = new ElementsFilter(wordTags);
        Element root = this.adornedXMLDocument.getRootElement();
        IteratorIterable iterator = root.getDescendants((Filter)filter);
        while (iterator.hasNext()) {
            Element wordElement = (Element)iterator.next();
            String wordText = wordElement.getText();
            String id = JDOMUtils.getAttributeValue(wordElement, "xml:id", false);
            this.wordIDs.add(id);
            List attributeList = wordElement.getAttributes();
            Map<String, String> attributeMap = MapFactory.createNewSortedMap();
            for (int i = 0; i < attributeList.size(); ++i) {
                Attribute attribute = (Attribute)attributeList.get(i);
                attributeMap.put(attribute.getQualifiedName(), attribute.getValue());
            }
            String siblingID = this.findSiblingID(wordElement, id);
            boolean blankPrecedes = this.ifBlankPrecedes(wordElement);
            AdornedWordData adornedWordData = new AdornedWordData(wordText, attributeMap, siblingID, blankPrecedes);
            this.adornedWordDataMap.put(id, adornedWordData);
        }
    }

    public AdornedWordsLoader(String adornedFileName) throws Exception {
        this(adornedFileName, new String[]{"w", "pc"});
    }

    public List<String> getAdornedWordIDs() {
        return this.wordIDs;
    }

    public AdornedWordData getAdornedWordData(String id) {
        return this.adornedWordDataMap.get(id);
    }

    public String findSiblingID(Element wordElement, String id) {
        String result = null;
        if (wordElement != null) {
            int i;
            Element parent = wordElement.getParentElement();
            List children = parent.getChildren();
            int index = children.indexOf(wordElement);
            for (i = index - 1; i >= 0; --i) {
                Element prevElement = (Element)children.get(i);
                if (!this.wordTagsSet.contains(prevElement.getName())) continue;
                result = JDOMUtils.getAttributeValue(prevElement, "xml:id", false);
                break;
            }
            if (result == null) {
                for (i = index + 1; i < children.size(); ++i) {
                    Element nextElement = (Element)children.get(i);
                    if (!this.wordTagsSet.contains(nextElement.getName())) continue;
                    result = JDOMUtils.getAttributeValue(nextElement, "xml:id", false);
                    break;
                }
            }
        }
        return result;
    }

    public boolean ifBlankPrecedes(Element wordElement) {
        Element parent;
        List children;
        int index;
        boolean result = false;
        if (wordElement != null && (index = (children = (parent = wordElement.getParentElement()).getChildren()).indexOf(wordElement)) > 0) {
            Element prevElement = (Element)children.get(index - 1);
            result = prevElement.getName().equals("c");
        }
        return result;
    }

    public Document getDocument() {
        return this.adornedXMLDocument;
    }

    public void releaseDocument() {
        this.adornedXMLDocument = null;
        System.gc();
    }
}

