/*
 * Decompiled with CFR 0.152.
 */
package edu.northwestern.at.morphadorner.tools.applyxslt;

import edu.northwestern.at.utils.FileBatchProcessor;
import edu.northwestern.at.utils.FileNameUtils;
import java.io.File;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.Templates;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;

public class ApplyXSLT {
    protected static Templates templates;
    protected static Source inputXML;
    protected static Result result;

    public static void main(String[] args) {
        try {
            ApplyXSLT.applyXSLT(args);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void applyXSLT(String[] args) throws Exception {
        FileBatchProcessor processor = new FileBatchProcessor(){

            @Override
            public void processOneFile(String inputFileName) throws Exception {
                inputXML = new StreamSource(inputFileName);
                String outputFileName = new File(this.outputDirectoryName, new File(inputFileName).getName()).toString();
                if (FileNameUtils.fileExists(outputFileName)) {
                    this.printStream.println("Skipping " + inputFileName);
                } else {
                    this.printStream.println("Processing " + inputFileName);
                    outputFileName = new File(outputFileName).toURI().toURL().toString();
                    try {
                        Transformer transformer = templates.newTransformer();
                        transformer.setOutputProperty("indent", "yes");
                        result = new StreamResult(outputFileName);
                        transformer.transform(inputXML, result);
                    }
                    catch (Exception e) {
                        this.printStream.println("   --- Error: " + inputFileName + ": " + e.getMessage());
                    }
                }
            }
        };
        processor.setOutputDirectoryName(args[0]);
        processor.setInputFileNames(args, 2);
        TransformerFactory factory = TransformerFactory.newInstance();
        StreamSource xslSource = new StreamSource(args[1]);
        templates = factory.newTemplates(xslSource);
        processor.run();
    }
}

