/*
 * Decompiled with CFR 0.152.
 */
package edu.northwestern.at.morphadorner.tools.annolex;

import edu.northwestern.at.morphadorner.tools.annolex.CorrectedWord;
import edu.northwestern.at.utils.ListFactory;
import edu.northwestern.at.utils.StringUtils;
import edu.northwestern.at.utils.csv.CSVFileReader;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class CorrectedWordsFileReader {
    public static final int TABFIELDSCOUNT = 9;
    protected static final int WORKID = 0;
    protected static final int WORDID = 1;
    protected static final int SPELL = 2;
    protected static final int CORSPELL = 3;
    protected static final int STANSPELL = 4;
    protected static final int CORLEM = 5;
    protected static final int CORPOS = 6;
    protected static final int CHECKBOX = 7;
    protected static final int UPDATEDID = 8;
    protected static Pattern gapWordPattern = Pattern.compile("(.*)-([0-9.]+)-gap([0-9])+$");
    protected static final Matcher gapWordMatcher = gapWordPattern.matcher("");
    protected int linesRead = 0;
    protected CSVFileReader tabFile = null;
    protected Set<String> allowedWorkIDs;
    protected CorrectedWord heldCorrectedWord = null;

    public CorrectedWordsFileReader(String tabInputFileName, Set<String> allowedWorkIDs) throws IOException {
        this.tabFile = new CSVFileReader(tabInputFileName, "utf-8", '\t', '\u0000');
        this.allowedWorkIDs = allowedWorkIDs;
    }

    public CorrectedWord readNextCorrectedWord() {
        CorrectedWord correctedWord = null;
        if (this.heldCorrectedWord != null) {
            correctedWord = this.heldCorrectedWord;
            this.heldCorrectedWord = null;
            return correctedWord;
        }
        List<String> fields = null;
        if (this.tabFile != null) {
            try {
                fields = this.tabFile.readFields();
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        if (fields != null) {
            ++this.linesRead;
            if (fields.size() < 9) {
                for (int i = fields.size(); i < 9; ++i) {
                    fields.add("");
                }
            }
            String workID = fields.get(0).trim();
            String id = fields.get(1).trim();
            String oldSpelling = fields.get(2).trim();
            String spelling = fields.get(3).trim();
            String lemmata = fields.get(5).trim();
            String partsOfSpeech = fields.get(6).trim();
            String correctionType = fields.get(7).trim();
            String standardSpelling = fields.get(4).trim();
            String updatedID = fields.get(8).trim();
            boolean addWord = true;
            if (this.allowedWorkIDs != null) {
                addWord = this.allowedWorkIDs.contains(workID);
            }
            if (addWord && !correctionType.equals("5")) {
                gapWordMatcher.reset(id);
                if (gapWordMatcher.find()) {
                    if (!partsOfSpeech.equals("zz")) {
                        int gapValue = Integer.parseInt(gapWordMatcher.group(3));
                        String sIdValue = gapWordMatcher.group(2);
                        int iPos = sIdValue.indexOf(".");
                        if (iPos >= 0) {
                            sIdValue = sIdValue.substring(0, iPos);
                        }
                        long idValue = Integer.parseInt(sIdValue);
                        String newIdValue = idValue + (long)gapValue + 1L + "";
                        updatedID = gapWordMatcher.group(1) + "-" + StringUtils.dupl("0", sIdValue.length() - newIdValue.length()) + newIdValue;
                        correctionType = "5";
                    } else {
                        addWord = false;
                    }
                }
            }
            if (addWord) {
                correctedWord = new CorrectedWord(workID, id, updatedID, oldSpelling, spelling, standardSpelling, lemmata, partsOfSpeech, correctionType);
            }
        } else {
            this.closeFile();
        }
        return correctedWord;
    }

    public Map<String, CorrectedWord> readCorrectedWords(int wordsToRead) {
        LinkedHashMap<String, CorrectedWord> correctedWordMap = new LinkedHashMap<String, CorrectedWord>();
        for (int i = 0; i < wordsToRead; ++i) {
            CorrectedWord correctedWord = this.readNextCorrectedWord();
            if (correctedWord != null) {
                correctedWordMap.put(correctedWord.getId(), correctedWord);
                continue;
            }
            if (this.tabFile == null) break;
        }
        return correctedWordMap;
    }

    public Map<String, CorrectedWord> readAllCorrectedWords() {
        return this.readCorrectedWords(Integer.MAX_VALUE);
    }

    public List<CorrectedWord> getCorrectedWords() {
        List<CorrectedWord> result = ListFactory.createNewList();
        Map<String, CorrectedWord> correctedWordMap = this.readAllCorrectedWords();
        for (String id : correctedWordMap.keySet()) {
            result.add(correctedWordMap.get(id));
        }
        return result;
    }

    public List<String> getCorrectedWordIDs() {
        List<String> result = ListFactory.createNewList();
        Map<String, CorrectedWord> correctedWordMap = this.readAllCorrectedWords();
        result.addAll(correctedWordMap.keySet());
        return result;
    }

    public void closeFile() {
        try {
            if (this.tabFile != null) {
                this.tabFile.close();
                this.tabFile = null;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

