/*
 * Decompiled with CFR 0.152.
 */
package edu.northwestern.at.morphadorner.tools.adornedtotcf;

import de.tuebingen.uni.sfs.dspin.tcf04.data.Lemma;
import de.tuebingen.uni.sfs.dspin.tcf04.data.Sentence;
import de.tuebingen.uni.sfs.dspin.tcf04.data.Tag;
import de.tuebingen.uni.sfs.dspin.tcf04.data.TextCorpusData;
import de.tuebingen.uni.sfs.dspin.tcf04.data.TextCorpusFactory;
import de.tuebingen.uni.sfs.dspin.tcf04.data.TextCorpusLayerTag;
import de.tuebingen.uni.sfs.dspin.tcf04.data.Token;
import de.tuebingen.uni.sfs.dspin.tcf04.descriptor.AttrBase;
import de.tuebingen.uni.sfs.dspin.tcf04.descriptor.LayerDescriptor;
import edu.northwestern.at.morphadorner.corpuslinguistics.sentencemelder.SentenceMelder;
import edu.northwestern.at.morphadorner.tools.AdornedXMLReader;
import edu.northwestern.at.morphadorner.tools.ExtendedAdornedWord;
import edu.northwestern.at.utils.Env;
import edu.northwestern.at.utils.FileNameUtils;
import edu.northwestern.at.utils.FileUtils;
import edu.northwestern.at.utils.Formatters;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;

public class AdornedToTCF04 {
    protected static int docsToProcess = 0;
    protected static int currentDocNumber = 0;
    protected static String inputDirectory;
    protected static String outputDirectory;
    protected static PrintStream outputFileStream;
    protected static PrintStream printStream;
    protected static final int INITPARAMS = 1;

    public static void main(String[] args) {
        try {
            if (!AdornedToTCF04.initialize(args)) {
                System.exit(1);
            }
            long startTime = System.currentTimeMillis();
            int filesProcessed = AdornedToTCF04.processFiles(args);
            long processingTime = (System.currentTimeMillis() - startTime + 999L) / 1000L;
            AdornedToTCF04.terminate(filesProcessed, processingTime);
        }
        catch (Exception e) {
            System.out.println(e.getMessage());
        }
    }

    protected static boolean initialize(String[] args) throws Exception {
        printStream = new PrintStream((OutputStream)new BufferedOutputStream(System.out), true, "utf-8");
        if (args.length < 2) {
            System.err.println("Not enough parameters.");
            return false;
        }
        outputDirectory = args[0];
        return true;
    }

    protected static void processOneFile(String xmlFileName) {
        String xmlOutputFileName = "";
        try {
            String shortInputXmlFileName = FileNameUtils.stripPathName(xmlFileName);
            String strippedFileName = FileNameUtils.changeFileExtension(shortInputXmlFileName, "");
            xmlOutputFileName = new File(outputDirectory, strippedFileName + ".xml").getAbsolutePath();
            FileUtils.createPathForFile(xmlOutputFileName);
            AdornedXMLReader xmlReader = new AdornedXMLReader(xmlFileName);
            List<List<ExtendedAdornedWord>> sentences = xmlReader.getSentences();
            FileOutputStream fos = new FileOutputStream(xmlOutputFileName);
            TextCorpusLayerTag[] layersToWrite = new TextCorpusLayerTag[]{TextCorpusLayerTag.TEXT, TextCorpusLayerTag.TOKENS, TextCorpusLayerTag.LEMMAS, TextCorpusLayerTag.POSTAGS, TextCorpusLayerTag.SENTENCES};
            TextCorpusData tc = new TextCorpusData((OutputStream)fos, layersToWrite, "en");
            ArrayList<Token> tokens = new ArrayList<Token>();
            ArrayList<Lemma> lemmata = new ArrayList<Lemma>();
            ArrayList<Tag> posTags = new ArrayList<Tag>();
            ArrayList<Sentence> tcfSentences = new ArrayList<Sentence>();
            StringBuilder sb = new StringBuilder();
            SentenceMelder melder = new SentenceMelder();
            TextCorpusFactory tcf = tc.getFactory();
            for (int i = 0; i < sentences.size(); ++i) {
                List<ExtendedAdornedWord> sentence = sentences.get(i);
                String sentenceText = melder.reconstituteSentence(sentence);
                sb.append(sentenceText);
                sb.append(Env.LINE_SEPARATOR);
                ArrayList<String> tokenRefs = new ArrayList<String>();
                for (int j = 0; j < sentence.size(); ++j) {
                    ExtendedAdornedWord word = sentence.get(j);
                    Token token = tcf.createToken(word.getSpelling());
                    MyToken myToken = new MyToken(token);
                    myToken.setID(word.getID());
                    tokens.add(token);
                    tokenRefs.add(token.getID());
                    Tag tag = tcf.createTag(word.getPartsOfSpeech(), new String[]{token.getID()});
                    posTags.add(tag);
                    Lemma lemma = tcf.createLemma(word.getLemmata(), new String[]{token.getID()});
                    lemmata.add(lemma);
                }
                Sentence tcfSentence = tcf.createSentence(tokenRefs);
                tcfSentences.add(tcfSentence);
            }
            tc.writeTextLayer(sb.toString());
            tc.writeTokensLayer(tokens);
            tc.writePOSTagsLayer(posTags, "NUPOS");
            tc.writeLemmasLayer(lemmata);
            tc.writeSentencesLayer(tcfSentences);
        }
        catch (Exception e) {
            printStream.println("Problem converting " + xmlFileName + " to " + xmlOutputFileName + ": " + e.getMessage());
        }
    }

    protected static int processFiles(String[] args) throws Exception {
        boolean result = false;
        String[] wildCards = new String[args.length - 1];
        for (int i = 1; i < args.length; ++i) {
            wildCards[i - 1] = args[i];
        }
        String[] fileNames = FileNameUtils.expandFileNameWildcards(wildCards);
        docsToProcess = fileNames.length;
        for (int i = 0; i < fileNames.length; ++i) {
            AdornedToTCF04.processOneFile(fileNames[i]);
        }
        return fileNames.length;
    }

    protected static void terminate(int filesProcessed, long processingTime) {
        printStream.println("Processed " + Formatters.formatIntegerWithCommas(filesProcessed) + " files in " + Formatters.formatLongWithCommas(processingTime) + " seconds.");
    }

    public static class MyToken {
        protected Token token;

        public MyToken(Token token) {
            this.token = token;
        }

        protected LayerDescriptor getDescriptor() throws Exception {
            Field privateLayerDescriptor = Token.class.getDeclaredField("layerDescriptor");
            privateLayerDescriptor.setAccessible(true);
            return (LayerDescriptor)privateLayerDescriptor.get(this.token);
        }

        public void setID(String ID2) {
            try {
                this.getDescriptor().getAttrs().remove(new AttrBase("ID", this.token.getID()));
                this.getDescriptor().getAttrs().add(new AttrBase("ID", ID2));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

