/*
 * Decompiled with CFR 0.152.
 */
package edu.northwestern.at.morphadorner.tools;

import edu.northwestern.at.morphadorner.WordAttributeNames;
import edu.northwestern.at.morphadorner.tools.ExtendedAdornedWord;
import edu.northwestern.at.utils.ListFactory;
import edu.northwestern.at.utils.MapFactory;
import edu.northwestern.at.utils.QueueStack;
import edu.northwestern.at.utils.xml.ExtendedXMLFilterImpl;
import edu.northwestern.at.utils.xml.TEITagClassifier;
import edu.northwestern.at.utils.xml.XMLTagClassifier;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.AttributesImpl;

public class ExtendedAdornedWordFilter
extends ExtendedXMLFilterImpl {
    protected Map<String, ExtendedAdornedWord> idToWordInfo;
    protected List<String> idList;
    protected List<String> tagList = ListFactory.createNewList();
    protected QueueStack<String> divStack = new QueueStack();
    protected List<ExtendedAdornedWord> lastWordList = ListFactory.createNewList();
    protected List<ExtendedAdornedWord> lastWordPartList = ListFactory.createNewList();
    protected ExtendedAdornedWord lastWordInfo = null;
    protected ExtendedAdornedWord lastWordPartInfo = null;
    protected XMLTagClassifier tagClassifier;
    protected boolean generateGapWords = false;
    protected String lastID = "";
    protected int gapCount = 0;
    protected int pageNumber = 0;
    protected Map<String, ExtendedAdornedWord> leadingGapWords = MapFactory.createNewLinkedMap();
    protected String firstWordID = "";
    protected String lastElementName = "";

    public ExtendedAdornedWordFilter(XMLReader reader) {
        this(reader, new TEITagClassifier(), false);
    }

    public ExtendedAdornedWordFilter(XMLReader reader, boolean generateGapWords) {
        this(reader, new TEITagClassifier(), generateGapWords);
    }

    public ExtendedAdornedWordFilter(XMLReader reader, XMLTagClassifier tagClassifier, boolean generateGapWords) {
        super(reader);
        this.tagClassifier = tagClassifier;
        this.generateGapWords = generateGapWords;
        this.lastID = "";
        this.lastElementName = "";
        this.idToWordInfo = MapFactory.createNewLinkedMap(25000);
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes atts) throws SAXException {
        boolean isW = qName.equals("w") || qName.equals("pc");
        boolean isGap = qName.equals("gap") && this.generateGapWords;
        boolean isPB = qName.equals("pb");
        boolean isDiv = qName.equals("div");
        String id = "";
        String label = "";
        boolean isSpoken = false;
        boolean isVerse = false;
        boolean inJumpTag = false;
        boolean isUnclear = false;
        String divType = "";
        AttributesImpl newAtts = new AttributesImpl(atts);
        if (isPB) {
            ++this.pageNumber;
        } else if (isDiv) {
            String divTypeAttr = atts.getValue("type");
            if (divTypeAttr == null) {
                divTypeAttr = atts.getValue("TYPE");
            }
            if (divTypeAttr == null || divTypeAttr.length() == 0) {
                divTypeAttr = "*div";
            }
            this.divStack.push(divTypeAttr.toLowerCase());
        }
        if (isW || isGap) {
            MainFront mainFront = this.getMainFront();
            if (isGap) {
                id = this.lastID + "-gap" + this.gapCount;
                label = newAtts.getValue(WordAttributeNames.label);
                ++this.gapCount;
                String path = newAtts.getValue(WordAttributeNames.p);
                String unit = newAtts.getValue("unit");
                String extent = newAtts.getValue("extent");
                String reason = newAtts.getValue("reason");
                String gapText = "{gap";
                if (unit != null) {
                    gapText = gapText + "-" + unit;
                }
                if (extent != null) {
                    gapText = gapText + "-" + extent;
                }
                if (reason != null) {
                    gapText = gapText + "-" + reason;
                }
                gapText = gapText + "}";
                newAtts = new AttributesImpl();
                this.setAttributeValue(newAtts, WordAttributeNames.id, id);
                this.setAttributeValue(newAtts, WordAttributeNames.eos, "0");
                this.setAttributeValue(newAtts, WordAttributeNames.lem, gapText);
                this.setAttributeValue(newAtts, WordAttributeNames.ord, -1);
                this.setAttributeValue(newAtts, WordAttributeNames.part, "N");
                this.setAttributeValue(newAtts, WordAttributeNames.p, path);
                this.setAttributeValue(newAtts, WordAttributeNames.pos, "zz");
                this.setAttributeValue(newAtts, WordAttributeNames.reg, gapText);
                this.setAttributeValue(newAtts, WordAttributeNames.spe, gapText);
                this.setAttributeValue(newAtts, WordAttributeNames.tok, gapText);
                this.setAttributeValue(newAtts, WordAttributeNames.label, label);
            } else {
                id = newAtts.getValue(WordAttributeNames.id);
                if (id == null) {
                    id = newAtts.getValue("id");
                }
                if (this.firstWordID.length() == 0) {
                    this.firstWordID = id;
                }
                this.lastID = id;
                this.gapCount = 0;
            }
            isSpoken = this.getSpoken();
            isVerse = this.getVerse();
            isUnclear = this.getUnclear();
            inJumpTag = this.getInJumpTag();
            divType = this.getDivType();
            ExtendedAdornedWord wordInfo = new ExtendedAdornedWord("", newAtts, mainFront.frontMiddleBack, mainFront.mainSide, null, this.pageNumber, isSpoken, isVerse, inJumpTag, isUnclear, divType, this.lastWordInfo, this.lastWordPartInfo, this.lastElementName.equals("c"));
            wordInfo.setGap(isGap);
            if (wordInfo.isFirstPart()) {
                if (this.lastWordInfo != null) {
                    this.lastWordInfo.setNextWord(wordInfo);
                }
                this.lastWordInfo = wordInfo;
            }
            if (this.lastWordInfo != null && this.lastWordInfo.isSplitWord()) {
                for (ExtendedAdornedWord nextPart = this.lastWordInfo.getNextWordPart(); nextPart != null; nextPart = nextPart.getNextWordPart()) {
                    nextPart.setNextWord(wordInfo);
                }
            }
            if (wordInfo.isSplitWord()) {
                if (wordInfo.isFirstPart()) {
                    wordInfo.setPreviousWordPart(null);
                } else if (this.lastWordPartInfo != null) {
                    this.lastWordPartInfo.setNextWordPart(wordInfo);
                }
                this.lastWordPartInfo = wordInfo;
            } else {
                this.lastWordPartInfo = null;
                wordInfo.setPreviousWordPart(null);
            }
            wordInfo.setWordIndex(this.idToWordInfo.size());
            this.idToWordInfo.put(id, wordInfo);
            if (isGap && this.lastID.length() == 0) {
                this.leadingGapWords.put(id, wordInfo);
            }
        } else if (!this.tagClassifier.isSoftTag(qName)) {
            if (this.tagClassifier.isJumpTag(qName)) {
                this.lastWordList.add(this.lastWordInfo);
                this.lastWordPartList.add(this.lastWordPartInfo);
            } else {
                this.lastWordList.add(null);
                this.lastWordPartList.add(null);
            }
            this.lastWordInfo = null;
            this.lastWordPartInfo = null;
        }
        this.tagList.add(qName);
        super.startElement(uri, localName, qName, atts);
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        ExtendedAdornedWord adornedWord;
        String currentTag = this.tagList.get(this.tagList.size() - 1);
        if ((currentTag.equals("w") || currentTag.equals("pc")) && (adornedWord = this.idToWordInfo.get(this.lastID)) != null) {
            adornedWord.appendWordText(ch, start, length);
        }
        super.characters(ch, start, length);
    }

    @Override
    public void ignorableWhitespace(char[] ch, int start, int length) throws SAXException {
        super.ignorableWhitespace(ch, start, length);
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        this.tagList.remove(this.tagList.size() - 1);
        if (!this.tagClassifier.isSoftTag(qName)) {
            int last = this.lastWordList.size() - 1;
            this.lastWordInfo = this.lastWordList.get(last);
            this.lastWordList.remove(last);
            last = this.lastWordPartList.size() - 1;
            this.lastWordPartInfo = this.lastWordPartList.get(last);
            this.lastWordPartList.remove(last);
        }
        if (qName.equalsIgnoreCase("div") && !this.divStack.isEmpty()) {
            this.divStack.pop();
        }
        this.lastElementName = qName;
        super.endElement(uri, localName, qName);
    }

    @Override
    public void endDocument() throws SAXException {
        super.endDocument();
        if (this.leadingGapWords.size() > 0) {
            this.fixLeadingGapWords();
            List<String> idList2 = ListFactory.createNewList(this.idToWordInfo.keySet());
            this.idList = ListFactory.createNewList();
            for (int i = 0; i < idList2.size(); ++i) {
                ExtendedAdornedWord word = this.idToWordInfo.get(idList2.get(i));
                this.idList.add(word.getID());
            }
            for (String oldID : this.leadingGapWords.keySet()) {
                ExtendedAdornedWord word = this.leadingGapWords.get(oldID);
                this.idToWordInfo.remove(oldID);
                this.idToWordInfo.put(word.getID(), word);
            }
        } else {
            this.idList = ListFactory.createNewList(this.idToWordInfo.keySet());
        }
        this.generateMissingExtendedAdornedWordInformation();
    }

    protected MainFront getMainFront() {
        ExtendedAdornedWord.FrontMiddleBack frontMiddleBack = ExtendedAdornedWord.FrontMiddleBack.MIDDLE;
        ExtendedAdornedWord.MainSide main = ExtendedAdornedWord.MainSide.MAIN;
        int iTagList = this.tagList.size() - 1;
        String ww = this.tagList.get(iTagList);
        String root = this.tagList.get(0);
        while (!ww.equals(root)) {
            String wwName = ww;
            String wwValue = this.tagClassifier.getTagClass(wwName);
            if (wwValue != null) {
                if (wwValue.equals("front")) {
                    frontMiddleBack = ExtendedAdornedWord.FrontMiddleBack.FRONT;
                } else if (wwValue.equals("back")) {
                    frontMiddleBack = ExtendedAdornedWord.FrontMiddleBack.BACK;
                } else if (wwValue.equals("side")) {
                    main = ExtendedAdornedWord.MainSide.SIDE;
                }
            }
            ww = this.tagList.get(--iTagList);
        }
        return new MainFront(frontMiddleBack, main);
    }

    public int getNumberOfWords() {
        return this.idList.size();
    }

    protected boolean getSpoken() {
        String tag;
        boolean result = false;
        for (int iTag = this.tagList.size() - 1; iTag >= 0 && !(tag = this.tagList.get(iTag)).equals("speaker"); --iTag) {
            boolean bl = result = result || this.tagList.get(iTag).equals("said") || this.tagList.get(iTag).equals("sp");
            if (result) break;
        }
        return result;
    }

    protected boolean getVerse() {
        boolean result = false;
        for (int iTag = this.tagList.size() - 1; iTag >= 0; --iTag) {
            boolean bl = result = result || this.tagList.get(iTag).equals("l");
            if (result) break;
        }
        return result;
    }

    protected boolean getUnclear() {
        boolean result = false;
        for (int iTag = this.tagList.size() - 1; iTag >= 0; --iTag) {
            boolean bl = result = result || this.tagList.get(iTag).equals("unclear");
            if (result) break;
        }
        return result;
    }

    protected boolean getInJumpTag() {
        boolean result = false;
        for (int iTag = this.tagList.size() - 1; iTag >= 0; --iTag) {
            boolean bl = result = result || this.tagClassifier.isJumpTag(this.tagList.get(iTag));
            if (result) break;
        }
        return result;
    }

    protected String getDivType() {
        String result = "";
        if (!this.divStack.isEmpty() && this.divStack.peek().length() > 0) {
            result = this.divStack.peek();
        }
        return result;
    }

    public List<String> getAdornedWordIDs() {
        return this.idList;
    }

    public ExtendedAdornedWord getExtendedAdornedWord(String id) {
        return this.idToWordInfo.get(id);
    }

    public ExtendedAdornedWord getExtendedAdornedWord(int index) {
        ExtendedAdornedWord result = null;
        String id = this.idList.get(index);
        if (id != null) {
            result = this.idToWordInfo.get(id);
        }
        return result;
    }

    public int getAdornedWordIndexByID(String id) {
        int result = -1;
        if (this.idToWordInfo.containsKey(id)) {
            result = this.idToWordInfo.get(id).getWordIndex();
        }
        return result;
    }

    public List<String> getAdornedWordIDsInReadingContextOrder() {
        List<String> sortedIDList = ListFactory.createNewList();
        List<String> jumpTagIDList = ListFactory.createNewList();
        for (String id : this.idList) {
            ExtendedAdornedWord word = this.idToWordInfo.get(id);
            if (word.getInJumpTag()) {
                jumpTagIDList.add(id);
                continue;
            }
            sortedIDList.add(id);
            if (!word.getEOS() || jumpTagIDList.size() <= 0) continue;
            sortedIDList.addAll(jumpTagIDList);
            jumpTagIDList.clear();
        }
        if (jumpTagIDList.size() > 0) {
            sortedIDList.addAll(jumpTagIDList);
        }
        return sortedIDList;
    }

    public List<List<ExtendedAdornedWord>> getSentences() {
        return this.getSentencesFromSentenceNumbers();
    }

    protected List<List<ExtendedAdornedWord>> getSentencesFromEOS() {
        List<ExtendedAdornedWord> sentence = ListFactory.createNewList();
        List<String> wordIDs = this.getAdornedWordIDsInReadingContextOrder();
        Map<Integer, List<ExtendedAdornedWord>> sentenceMap = MapFactory.createNewSortedMap();
        int startingWordIndex = 0;
        for (int i = 0; i < wordIDs.size(); ++i) {
            ExtendedAdornedWord wordInfo = this.getExtendedAdornedWord(wordIDs.get(i));
            if (!wordInfo.isFirstPart()) continue;
            if (sentence.size() == 0) {
                startingWordIndex = this.getAdornedWordIndexByID(wordIDs.get(i));
            }
            sentence.add(wordInfo);
            if (!wordInfo.getEOS()) continue;
            sentenceMap.put(startingWordIndex, sentence);
            sentence = ListFactory.createNewList();
        }
        if (sentence.size() > 0) {
            sentenceMap.put(startingWordIndex, sentence);
        }
        List<List<ExtendedAdornedWord>> sentences = ListFactory.createNewList();
        for (Integer sentenceIndex : sentenceMap.keySet()) {
            sentences.add((List<ExtendedAdornedWord>)sentenceMap.get(sentenceIndex));
        }
        return sentences;
    }

    protected List<List<ExtendedAdornedWord>> getSentencesFromSentenceNumbers() {
        List<String> wordIDs = this.getAdornedWordIDsInReadingContextOrder();
        Map sentenceMap = MapFactory.createNewSortedMap();
        for (int i = 0; i < wordIDs.size(); ++i) {
            int wordNumber;
            ExtendedAdornedWord wordInfo = this.getExtendedAdornedWord(wordIDs.get(i));
            if (!wordInfo.isFirstPart()) continue;
            int sentenceNumber = wordInfo.getSentenceNumber();
            List<ExtendedAdornedWord> sentence = (List<ExtendedAdornedWord>)sentenceMap.get(sentenceNumber);
            if (sentence == null) {
                sentence = ListFactory.createNewList();
                sentenceMap.put(sentenceNumber, sentence);
            }
            if ((wordNumber = wordInfo.getWordNumber()) == -1) {
                wordInfo.setWordNumber(sentence.size() + 1);
                sentence.add(wordInfo);
                continue;
            }
            try {
                sentence.add(wordNumber - 1, wordInfo);
                continue;
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        List<List<ExtendedAdornedWord>> sentences = ListFactory.createNewList();
        for (Integer sentenceNumber : sentenceMap.keySet()) {
            sentences.add((List<ExtendedAdornedWord>)sentenceMap.get(sentenceNumber));
        }
        return sentences;
    }

    public List<String> getRelatedSplitWordIDs(String wordID) {
        List<String> result = null;
        ExtendedAdornedWord adornedWordInfo = this.getExtendedAdornedWord(wordID);
        if (adornedWordInfo != null) {
            result = ListFactory.createNewList();
            ExtendedAdornedWord prevPart = adornedWordInfo;
            while (prevPart != null) {
                adornedWordInfo = prevPart;
                prevPart = adornedWordInfo.getPreviousWordPart();
            }
            while (adornedWordInfo != null) {
                result.add(adornedWordInfo.getID());
                adornedWordInfo = adornedWordInfo.getNextWordPart();
            }
        }
        return result;
    }

    public List<ExtendedAdornedWord> getRelatedSplitWords(ExtendedAdornedWord adornedWordInfo) {
        List<ExtendedAdornedWord> result = null;
        if (adornedWordInfo != null) {
            ExtendedAdornedWord wordInfo = adornedWordInfo;
            result = ListFactory.createNewList();
            ExtendedAdornedWord prevPart = wordInfo;
            while (prevPart != null) {
                wordInfo = prevPart;
                prevPart = wordInfo.getPreviousWordPart();
            }
            while (wordInfo != null) {
                result.add(wordInfo);
                wordInfo = wordInfo.getNextWordPart();
            }
        }
        return result;
    }

    public String trimTag(String tag) {
        String result = tag.trim();
        int lbPos = result.indexOf("[");
        if (lbPos >= 0) {
            result = result.substring(0, lbPos);
        }
        return result;
    }

    public String[] splitPathFull(String path) {
        String[] tags = path.split("\\\\");
        String[] result = new String[tags.length - 1];
        int j = 0;
        for (int i = 0; i < tags.length - 1; ++i) {
            result[j++] = tags[i];
        }
        return result;
    }

    public String[] splitPath(String path) {
        String[] tags = this.splitPathFull(path);
        String[] result = new String[tags.length - 2];
        int j = 0;
        for (int i = 2; i < tags.length; ++i) {
            result[j++] = tags[i];
        }
        return result;
    }

    public String trimTrailingSoftTags(String path) {
        String tag;
        String[] pathTags = this.splitPathFull(path);
        int l = pathTags.length - 2;
        for (l = pathTags.length - 2; l > 0 && this.tagClassifier.isSoftTag(tag = this.trimTag(pathTags[l])); --l) {
        }
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i <= l; ++i) {
            if (i > 0) {
                sb.append("\\");
            }
            sb.append(pathTags[i]);
        }
        return sb.toString();
    }

    public List<String> getSiblingWordIDs(String wordID) {
        List<String> result = ListFactory.createNewList();
        ExtendedAdornedWord word = this.getExtendedAdornedWord(wordID);
        String path = word.getPath();
        if (path != null) {
            result = this.findWordsByMatchingLeadingPath(this.trimTrailingSoftTags(path));
        }
        return result;
    }

    public List<String> findWordsByMatchingPath(String pattern) {
        List<String> result = ListFactory.createNewList();
        Pattern pat = Pattern.compile(pattern);
        Matcher matcher = pat.matcher("");
        for (int i = 0; i < this.idList.size(); ++i) {
            ExtendedAdornedWord word = this.getExtendedAdornedWord(this.idList.get(i));
            String path = word.getPath();
            matcher.reset(path);
            if (!matcher.find()) continue;
            result.add(this.idList.get(i));
        }
        return result;
    }

    public List<String> findWordsByMatchingLeadingPath(String pattern) {
        List<String> result = ListFactory.createNewList();
        for (int i = 0; i < this.idList.size(); ++i) {
            ExtendedAdornedWord word = this.getExtendedAdornedWord(this.idList.get(i));
            String path = word.getPath();
            if (!path.startsWith(pattern)) continue;
            result.add(this.idList.get(i));
        }
        return result;
    }

    protected List<String> getSelectedWordIDs(String startingWordID, String endingWordID) {
        List<String> result = ListFactory.createNewList();
        int startingIndex = this.getAdornedWordIndexByID(startingWordID);
        int endingIndex = this.getAdornedWordIndexByID(endingWordID);
        if (startingIndex >= 0 && endingIndex >= 0 && endingIndex >= startingIndex) {
            for (int i = startingIndex; i <= endingIndex; ++i) {
                result.add(this.idList.get(i));
            }
        }
        return result;
    }

    protected void addWordOrdinals() {
        int wordOrd = 1;
        for (int i = 0; i < this.idList.size(); ++i) {
            ExtendedAdornedWord wordInfo = this.getExtendedAdornedWord(this.idList.get(i));
            if (!wordInfo.isFirstPart()) continue;
            wordInfo.setOrd(wordOrd);
            List<ExtendedAdornedWord> relatedWords = this.getRelatedSplitWords(wordInfo);
            if (relatedWords.size() > 1) {
                for (int k = 0; k < relatedWords.size(); ++k) {
                    ExtendedAdornedWord relWordInfo = relatedWords.get(k);
                    relWordInfo.setOrd(wordOrd);
                    this.idToWordInfo.put(relWordInfo.getID(), relWordInfo);
                }
            }
            ++wordOrd;
        }
    }

    protected void fixLeadingGapWords() {
        String baseGapID = "";
        if (this.firstWordID.length() == 0) {
            baseGapID = "0";
        } else {
            char[] idChars = this.firstWordID.toCharArray();
            for (int i = idChars.length - 1; i > 0 && idChars[i] != '-' && Character.isDigit(idChars[i]); --i) {
                idChars[i] = 48;
            }
            baseGapID = new String(idChars);
        }
        int gapCount = 0;
        for (String gapID : this.leadingGapWords.keySet()) {
            ExtendedAdornedWord gapWord = this.leadingGapWords.get(gapID);
            String id = baseGapID + "-gap" + gapCount++;
            gapWord.setID(id);
        }
    }

    protected void generateMissingExtendedAdornedWordInformation() {
        block15: {
            boolean needSentenceNumbers;
            boolean needWordNumbers;
            ExtendedAdornedWord wordInfo;
            block14: {
                List<String> wordIDs = this.getAdornedWordIDsInReadingContextOrder();
                wordInfo = this.getExtendedAdornedWord(wordIDs.get(0));
                if (wordInfo == null) {
                    return;
                }
                needWordNumbers = wordInfo.getWordNumber() == -1;
                needSentenceNumbers = wordInfo.getSentenceNumber() == -1;
                int eosFound = 0;
                int ordFound = 0;
                for (int i = 0; i < wordIDs.size(); ++i) {
                    wordInfo = this.getExtendedAdornedWord(wordIDs.get(i));
                    String wordText = this.getWordText(wordInfo);
                    if (wordInfo.getToken().length() == 0) {
                        wordInfo.setToken(wordText);
                    }
                    if (wordInfo.getSpelling().length() == 0) {
                        wordInfo.setSpelling(wordText);
                    }
                    if (wordInfo.getLemmata().length() == 0) {
                        wordInfo.setLemmata(wordInfo.getSpelling());
                    }
                    if (wordInfo.getPartsOfSpeech().length() == 0) {
                        wordInfo.setPartsOfSpeech(wordInfo.getSpelling());
                    }
                    if (wordInfo.getStandardSpelling().length() == 0) {
                        wordInfo.setStandardSpelling(wordInfo.getSpelling());
                    }
                    if (wordInfo.getEOS()) {
                        ++eosFound;
                    }
                    if (wordInfo.getOrd() <= 0) continue;
                    ++ordFound;
                }
                if (ordFound == 0) {
                    this.addWordOrdinals();
                }
                if (eosFound != 0) break block14;
                List<List<ExtendedAdornedWord>> sentences = this.getSentencesFromSentenceNumbers();
                for (int i = 0; i < sentences.size(); ++i) {
                    List<ExtendedAdornedWord> sentence = sentences.get(i);
                    wordInfo = sentence.get(sentence.size() - 1);
                    wordInfo.setEOS(true);
                    List<ExtendedAdornedWord> relatedWords = this.getRelatedSplitWords(wordInfo);
                    if (relatedWords.size() <= 1) continue;
                    for (int k = 0; k < relatedWords.size(); ++k) {
                        ExtendedAdornedWord relWordInfo = relatedWords.get(k);
                        relWordInfo.setEOS(true);
                        this.idToWordInfo.put(relWordInfo.getID(), relWordInfo);
                    }
                }
                break block15;
            }
            if (!needWordNumbers && !needSentenceNumbers) break block15;
            List<List<ExtendedAdornedWord>> sentences = this.getSentencesFromEOS();
            for (int i = 0; i < sentences.size(); ++i) {
                List<ExtendedAdornedWord> sentence = sentences.get(i);
                for (int j = 0; j < sentence.size(); ++j) {
                    wordInfo = sentence.get(j);
                    wordInfo.setWordNumber(j + 1);
                    wordInfo.setSentenceNumber(i + 1);
                    this.idToWordInfo.put(wordInfo.getID(), wordInfo);
                    List<ExtendedAdornedWord> relatedWords = this.getRelatedSplitWords(wordInfo);
                    if (relatedWords.size() <= 1) continue;
                    for (int k = 0; k < relatedWords.size(); ++k) {
                        ExtendedAdornedWord relWordInfo = relatedWords.get(k);
                        relWordInfo.setWordNumber(j + 1);
                        relWordInfo.setSentenceNumber(i + 1);
                        this.idToWordInfo.put(relWordInfo.getID(), relWordInfo);
                    }
                }
            }
        }
    }

    protected String getWordText(ExtendedAdornedWord adornedWord) {
        String result = adornedWord.getWordText();
        if (adornedWord.isSplitWord()) {
            String id = adornedWord.getID();
            List<String> relatedIDs = this.getRelatedSplitWordIDs(id);
            result = "";
            for (int j = 0; j < relatedIDs.size(); ++j) {
                ExtendedAdornedWord relatedWord = this.getExtendedAdornedWord(relatedIDs.get(j));
                if (j > 0 && relatedWord.getBlankPrecedes()) {
                    result = result + " ";
                }
                result = result + relatedWord.getWordText();
            }
        }
        return result;
    }

    class MainFront {
        ExtendedAdornedWord.MainSide mainSide;
        ExtendedAdornedWord.FrontMiddleBack frontMiddleBack;

        public MainFront(ExtendedAdornedWord.FrontMiddleBack frontMiddleBack, ExtendedAdornedWord.MainSide mainSide) {
            this.frontMiddleBack = frontMiddleBack;
            this.mainSide = mainSide;
        }
    }
}

