/*
 * Decompiled with CFR 0.152.
 */
package edu.northwestern.at.morphadorner.tools;

import edu.northwestern.at.morphadorner.WordAttributeNames;
import edu.northwestern.at.morphadorner.corpuslinguistics.adornedword.AdornedWord;
import edu.northwestern.at.morphadorner.corpuslinguistics.adornedword.BaseAdornedWord;
import edu.northwestern.at.utils.HasID;
import edu.northwestern.at.utils.StringUtils;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Map;
import org.xml.sax.Attributes;

public class ExtendedAdornedWord
extends BaseAdornedWord
implements AdornedWord,
HasID,
Externalizable {
    protected byte[] id;
    protected String wordText;
    protected String part;
    protected boolean eos;
    protected int ord;
    protected MainSide mainSide;
    protected boolean isSpoken;
    protected boolean isVerse;
    protected boolean inJumpTag;
    protected FrontMiddleBack frontMiddleBack;
    protected ExtendedAdornedWord previousWord;
    protected ExtendedAdornedWord nextWord;
    protected ExtendedAdornedWord previousWordPart;
    protected ExtendedAdornedWord nextWordPart;
    protected byte[] path;
    protected int sentenceNumber;
    protected int wordNumber;
    protected boolean isGap;
    protected int wordIndex;
    protected int pageNumber;
    protected String label;
    protected boolean isUnclear;
    protected String rend;
    protected String type;
    protected String divType;
    protected boolean blankPrecedes;
    protected static final long serialVersionUID = -1L;

    public ExtendedAdornedWord() {
    }

    public ExtendedAdornedWord(String wordText, Attributes atts, FrontMiddleBack frontMiddleBack, MainSide mainSide, String tagPath, int pageNumber, boolean isSpoken, boolean isVerse, boolean inJumpTag, boolean isUnclear, String divType, ExtendedAdornedWord previousWord, ExtendedAdornedWord previousWordPart, boolean blankPrecedes) {
        String lemAttr;
        this.wordText = StringUtils.safeString(wordText);
        String idString = atts.getValue(WordAttributeNames.id);
        if (idString == null) {
            idString = atts.getValue("id");
        }
        if (idString != null) {
            this.id = StringUtils.getUTF8Bytes(idString);
        }
        this.ord = StringUtils.stringToInt(atts.getValue(WordAttributeNames.ord), 0);
        this.token = StringUtils.safeString(atts.getValue(WordAttributeNames.tok));
        if (this.token.length() == 0) {
            this.token = wordText;
        }
        this.spelling = StringUtils.safeString(atts.getValue(WordAttributeNames.spe));
        if (this.spelling.length() == 0) {
            this.spelling = wordText;
        }
        this.partsOfSpeech = atts.getValue(WordAttributeNames.pos);
        if (this.partsOfSpeech == null) {
            this.partsOfSpeech = StringUtils.safeString(atts.getValue(WordAttributeNames.teiPos));
            if (this.partsOfSpeech.startsWith("#")) {
                this.partsOfSpeech = this.partsOfSpeech.substring(1);
            }
        } else {
            this.partsOfSpeech = StringUtils.safeString(this.partsOfSpeech);
        }
        this.part = atts.getValue(WordAttributeNames.part);
        if (this.part == null) {
            this.part = "N";
        }
        this.eos = StringUtils.safeString(atts.getValue(WordAttributeNames.eos)).equals("1");
        String unit = StringUtils.safeString(atts.getValue("unit"));
        if (unit.equals("sentence")) {
            this.eos = true;
        }
        if ((lemAttr = atts.getValue(WordAttributeNames.lem)) == null) {
            lemAttr = atts.getValue(WordAttributeNames.teiLem);
        }
        this.lemmata = StringUtils.safeString(lemAttr);
        this.standardSpelling = StringUtils.safeString(atts.getValue(WordAttributeNames.reg));
        this.path = tagPath == null ? StringUtils.getUTF8Bytes(atts.getValue(WordAttributeNames.p)) : StringUtils.getUTF8Bytes(tagPath);
        this.wordNumber = StringUtils.stringToInt(atts.getValue(WordAttributeNames.wn), -1);
        this.sentenceNumber = StringUtils.stringToInt(atts.getValue(WordAttributeNames.sn), -1);
        this.label = StringUtils.safeString(atts.getValue(WordAttributeNames.n));
        this.rend = StringUtils.safeString(atts.getValue(WordAttributeNames.rend));
        this.type = StringUtils.safeString(atts.getValue(WordAttributeNames.type));
        this.pageNumber = pageNumber;
        this.frontMiddleBack = frontMiddleBack;
        this.mainSide = mainSide;
        this.isSpoken = isSpoken;
        this.isVerse = isVerse;
        this.inJumpTag = inJumpTag;
        this.isUnclear = isUnclear;
        this.divType = divType;
        this.previousWord = previousWord;
        this.nextWord = null;
        this.previousWordPart = previousWordPart;
        this.nextWordPart = null;
        this.wordIndex = 0;
        this.blankPrecedes = blankPrecedes;
    }

    public ExtendedAdornedWord(String wordText, Map<String, String> atts, FrontMiddleBack frontMiddleBack, MainSide mainSide, String tagPath, int pageNumber, boolean isSpoken, boolean isVerse, boolean inJumpTag, boolean isUnclear, String divType, ExtendedAdornedWord previousWord, ExtendedAdornedWord previousWordPart, boolean blankPrecedes) {
        String lemAttr;
        this.wordText = StringUtils.safeString(wordText);
        String idString = atts.get(WordAttributeNames.id);
        if (idString == null) {
            idString = atts.get("id");
        }
        if (idString != null) {
            this.id = StringUtils.getUTF8Bytes(idString);
        }
        this.ord = StringUtils.stringToInt(atts.get(WordAttributeNames.ord), 0);
        this.token = StringUtils.safeString(atts.get(WordAttributeNames.tok));
        if (this.token.length() == 0) {
            this.token = wordText;
        }
        this.spelling = StringUtils.safeString(atts.get(WordAttributeNames.spe));
        if (this.spelling.length() == 0) {
            this.spelling = wordText;
        }
        this.partsOfSpeech = atts.get(WordAttributeNames.pos);
        if (this.partsOfSpeech == null) {
            this.partsOfSpeech = StringUtils.safeString(atts.get(WordAttributeNames.teiPos));
            if (this.partsOfSpeech.startsWith("#")) {
                this.partsOfSpeech = this.partsOfSpeech.substring(1);
            }
        } else {
            this.partsOfSpeech = StringUtils.safeString(this.partsOfSpeech);
        }
        this.part = atts.get(WordAttributeNames.part);
        if (this.part == null) {
            this.part = "N";
        }
        this.eos = StringUtils.safeString(atts.get(WordAttributeNames.eos)).equals("1");
        String unit = StringUtils.safeString(atts.get("unit"));
        if (unit.equals("sentence")) {
            this.eos = true;
        }
        if ((lemAttr = atts.get(WordAttributeNames.lem)) == null) {
            lemAttr = atts.get(WordAttributeNames.teiLem);
        }
        this.lemmata = StringUtils.safeString(lemAttr);
        this.standardSpelling = StringUtils.safeString(atts.get(WordAttributeNames.reg));
        this.path = tagPath == null ? StringUtils.getUTF8Bytes(atts.get(WordAttributeNames.p)) : StringUtils.getUTF8Bytes(tagPath);
        this.wordNumber = StringUtils.stringToInt(atts.get(WordAttributeNames.wn), -1);
        this.sentenceNumber = StringUtils.stringToInt(atts.get(WordAttributeNames.sn), -1);
        this.label = StringUtils.safeString(atts.get(WordAttributeNames.n));
        this.rend = StringUtils.safeString(atts.get(WordAttributeNames.rend));
        this.type = StringUtils.safeString(atts.get(WordAttributeNames.type));
        this.pageNumber = pageNumber;
        this.frontMiddleBack = frontMiddleBack;
        this.mainSide = mainSide;
        this.isSpoken = isSpoken;
        this.isVerse = isVerse;
        this.inJumpTag = inJumpTag;
        this.isUnclear = isUnclear;
        this.divType = divType;
        this.previousWord = previousWord;
        this.nextWord = null;
        this.previousWordPart = previousWordPart;
        this.nextWordPart = null;
        this.wordIndex = 0;
        this.blankPrecedes = blankPrecedes;
    }

    public ExtendedAdornedWord(AdornedWord adornedWord, String id, String label, String part, int ord, int pageNumber, boolean eos, int wordNumber, int sentenceNumber, FrontMiddleBack frontMiddleBack, MainSide mainSide, String tagPath, boolean isSpoken, boolean isVerse, boolean isUnclear, String rend, String type, ExtendedAdornedWord previousWord, ExtendedAdornedWord previousWordPart, boolean blankPrecedes) {
        this.wordText = adornedWord.getToken();
        this.id = StringUtils.getUTF8Bytes(id);
        this.label = label;
        this.ord = ord;
        this.token = adornedWord.getToken();
        this.spelling = adornedWord.getSpelling();
        this.partsOfSpeech = adornedWord.getPartsOfSpeech();
        this.lemmata = adornedWord.getLemmata();
        this.standardSpelling = adornedWord.getStandardSpelling();
        this.part = part;
        this.eos = eos;
        this.path = StringUtils.getUTF8Bytes(tagPath);
        this.wordNumber = wordNumber;
        this.sentenceNumber = sentenceNumber;
        this.pageNumber = pageNumber;
        this.frontMiddleBack = frontMiddleBack;
        this.mainSide = mainSide;
        this.rend = StringUtils.safeString(rend);
        this.type = StringUtils.safeString(type);
        this.isSpoken = isSpoken;
        this.isVerse = isVerse;
        this.isUnclear = isUnclear;
        this.inJumpTag = this.inJumpTag;
        this.previousWord = previousWord;
        this.nextWord = null;
        this.previousWordPart = previousWordPart;
        this.nextWordPart = null;
        this.blankPrecedes = blankPrecedes;
        this.wordIndex = 0;
    }

    @Override
    public String getID() {
        return StringUtils.getStringFromUTF8Bytes(this.id);
    }

    public void setID(String id) {
        this.id = StringUtils.getUTF8Bytes(id);
    }

    public String getPart() {
        return this.part;
    }

    public String getPath() {
        return StringUtils.getStringFromUTF8Bytes(this.path);
    }

    public boolean isFirstPart() {
        return this.part.equals("N") || this.part.equals("I");
    }

    public boolean isMiddlePart() {
        return this.part.equals("N") || this.part.equals("M");
    }

    public boolean isLastPart() {
        return this.part.equals("N") || this.part.equals("F");
    }

    public boolean isSplitWord() {
        return !this.part.equals("N");
    }

    public int getOrd() {
        return this.ord;
    }

    public void setOrd(int ord) {
        this.ord = ord;
    }

    public int getSentenceNumber() {
        return this.sentenceNumber;
    }

    public void setSentenceNumber(int sentenceNumber) {
        this.sentenceNumber = sentenceNumber;
    }

    public int getWordNumber() {
        return this.wordNumber;
    }

    public void setWordNumber(int wordNumber) {
        this.wordNumber = wordNumber;
    }

    public int getPageNumber() {
        return this.pageNumber;
    }

    public void setPageNumber(int pageNumber) {
        this.pageNumber = pageNumber;
    }

    public String getLabel() {
        return this.label;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public boolean getIsUnclear() {
        return this.isUnclear || this.type.equals("unclear");
    }

    public void setIsUnclear(boolean isUnclear) {
        this.isUnclear = isUnclear;
    }

    public String getRend() {
        return this.rend;
    }

    public void setRend(String rend) {
        this.rend = StringUtils.safeString(rend);
    }

    public void appendRend(String rend) {
        this.rend = this.rend.length() > 0 ? this.rend + " " + rend : rend;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = StringUtils.safeString(type);
    }

    public boolean getEOS() {
        return this.eos;
    }

    public void setEOS(boolean eos) {
        this.eos = eos;
    }

    public MainSide getMainSide() {
        return this.mainSide;
    }

    public FrontMiddleBack getFrontMiddleBack() {
        return this.frontMiddleBack;
    }

    public boolean getSpoken() {
        return this.isSpoken;
    }

    public void setSpoken(boolean isSpoken) {
        this.isSpoken = isSpoken;
    }

    public boolean getVerse() {
        return this.isVerse;
    }

    public void setVerse(boolean isVerse) {
        this.isVerse = isVerse;
    }

    public boolean getInJumpTag() {
        return this.inJumpTag;
    }

    public void setInJumpTag(boolean inJumpTag) {
        this.inJumpTag = inJumpTag;
    }

    public boolean getGap() {
        return this.isGap;
    }

    public void setGap(boolean isGap) {
        this.isGap = isGap;
    }

    public String getWordText() {
        return this.wordText;
    }

    public void setWordText(String wordText) {
        this.wordText = wordText;
    }

    public void setWordText(char[] ch, int start, int length) {
        this.wordText = "";
        for (int i = start; i < start + length; ++i) {
            this.wordText = this.wordText + ch[i];
        }
    }

    public ExtendedAdornedWord getNextWord() {
        return this.nextWord;
    }

    public void setNextWord(ExtendedAdornedWord nextWord) {
        this.nextWord = nextWord;
    }

    public ExtendedAdornedWord getPreviousWord() {
        return this.previousWord;
    }

    public void setPreviousWord(ExtendedAdornedWord previousWord) {
        this.previousWord = previousWord;
    }

    public ExtendedAdornedWord getNextWordPart() {
        return this.nextWordPart;
    }

    public void setNextWordPart(ExtendedAdornedWord nextWordPart) {
        this.nextWordPart = nextWordPart;
    }

    public ExtendedAdornedWord getPreviousWordPart() {
        return this.previousWordPart;
    }

    public void setPreviousWordPart(ExtendedAdornedWord previousWordPart) {
        this.previousWordPart = previousWordPart;
    }

    public int getWordIndex() {
        return this.wordIndex;
    }

    public void setWordIndex(int wordIndex) {
        this.wordIndex = wordIndex;
    }

    public String getDivType() {
        return this.divType;
    }

    public void setDivType(String divType) {
        this.divType = divType;
    }

    public boolean getBlankPrecedes() {
        return this.blankPrecedes;
    }

    public void setBlankPrecedes(boolean blankPrecedes) {
        this.blankPrecedes = blankPrecedes;
    }

    public void appendWordText(char[] ch, int start, int length) {
        for (int i = start; i < start + length; ++i) {
            this.wordText = this.wordText + ch[i];
        }
        if (this.token == null) {
            this.token = this.wordText;
        }
        if (this.spelling == null) {
            this.spelling = this.wordText;
        }
        if (this.lemmata == null) {
            this.lemmata = this.wordText;
        }
        if (this.standardSpelling == null) {
            this.standardSpelling = this.wordText;
        }
    }

    public void appendWordText(String s) {
        this.wordText = this.wordText + s;
        if (this.token == null) {
            this.token = this.wordText;
        }
        if (this.spelling == null) {
            this.spelling = this.wordText;
        }
        if (this.lemmata == null) {
            this.lemmata = this.wordText;
        }
        if (this.standardSpelling == null) {
            this.standardSpelling = this.wordText;
        }
    }

    @Override
    public String toString() {
        return this.spelling;
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeObject(this.token);
        out.writeObject(this.spelling);
        out.writeObject(this.standardSpelling);
        out.writeObject(this.lemmata);
        out.writeObject(this.partsOfSpeech);
        out.writeObject(this.id);
        out.writeObject(this.wordText);
        out.writeObject(this.part);
        out.writeBoolean(this.eos);
        out.writeInt(this.ord);
        out.writeObject((Object)this.mainSide);
        out.writeBoolean(this.isSpoken);
        out.writeBoolean(this.isVerse);
        out.writeBoolean(this.inJumpTag);
        out.writeObject((Object)this.frontMiddleBack);
        out.writeObject(this.previousWord);
        out.writeObject(this.nextWord);
        out.writeObject(this.previousWordPart);
        out.writeObject(this.nextWordPart);
        out.writeObject(this.path);
        out.writeInt(this.sentenceNumber);
        out.writeInt(this.wordNumber);
        out.writeInt(this.wordIndex);
        out.writeInt(this.pageNumber);
        out.writeObject(this.label);
        out.writeObject(this.rend);
        out.writeObject(this.type);
        out.writeObject(this.divType);
        out.writeObject(this.isUnclear);
        out.writeBoolean(this.isGap);
        out.writeBoolean(this.blankPrecedes);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.token = (String)in.readObject();
        this.spelling = (String)in.readObject();
        this.standardSpelling = (String)in.readObject();
        this.lemmata = (String)in.readObject();
        this.partsOfSpeech = (String)in.readObject();
        this.id = (byte[])in.readObject();
        this.wordText = (String)in.readObject();
        this.part = (String)in.readObject();
        this.eos = in.readBoolean();
        this.ord = in.readInt();
        this.mainSide = (MainSide)((Object)in.readObject());
        this.isSpoken = in.readBoolean();
        this.isVerse = in.readBoolean();
        this.inJumpTag = in.readBoolean();
        this.frontMiddleBack = (FrontMiddleBack)((Object)in.readObject());
        this.previousWord = (ExtendedAdornedWord)in.readObject();
        this.nextWord = (ExtendedAdornedWord)in.readObject();
        this.previousWordPart = (ExtendedAdornedWord)in.readObject();
        this.nextWordPart = (ExtendedAdornedWord)in.readObject();
        this.path = (byte[])in.readObject();
        this.sentenceNumber = in.readInt();
        this.wordNumber = in.readInt();
        this.wordIndex = in.readInt();
        this.pageNumber = in.readInt();
        this.label = (String)in.readObject();
        this.rend = (String)in.readObject();
        this.type = (String)in.readObject();
        this.divType = (String)in.readObject();
        this.isUnclear = in.readBoolean();
        this.isGap = in.readBoolean();
        this.blankPrecedes = in.readBoolean();
    }

    public static enum MainSide {
        MAIN,
        SIDE;

    }

    public static enum FrontMiddleBack {
        FRONT,
        MIDDLE,
        BACK;

    }
}

