/*
 * Decompiled with CFR 0.152.
 */
package edu.northwestern.at.morphadorner.tei;

import edu.northwestern.at.morphadorner.tei.TEIHeaderAuthor;
import edu.northwestern.at.utils.FileNameUtils;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamReader;

public class TEIHeaderInfo {
    String fileName = null;
    String title = null;
    protected List<TEIHeaderAuthor> authorList = new ArrayList<TEIHeaderAuthor>();
    protected Map<String, String> authorMap = null;

    public TEIHeaderInfo(String teiXMLFileName) {
        this.fileName = FileNameUtils.stripPathName(teiXMLFileName);
        this.fileName = FileNameUtils.changeFileExtension(this.fileName, "");
        this.parseXML(teiXMLFileName);
    }

    public String getFileName() {
        return this.fileName;
    }

    public String getTitle() {
        return this.safeString(this.title);
    }

    public List<TEIHeaderAuthor> getAuthors() {
        return this.authorList;
    }

    protected void parseXML(String xmlFile) {
        try {
            FileInputStream fileInputStream = new FileInputStream(xmlFile);
            XMLStreamReader parser = XMLInputFactory.newInstance().createXMLStreamReader(fileInputStream);
            int inBiblFull = 0;
            int inTitleStmt = 0;
            int inAuthor = 0;
            int inTitle = 0;
            boolean seenBiblFull = false;
            boolean done = false;
            String currentElement = "";
            int event = parser.next();
            while (!done && event != 8) {
                switch (event) {
                    case 1: {
                        currentElement = parser.getLocalName();
                        if (TEIHeaderInfo.isBiblFull(currentElement)) {
                            ++inBiblFull;
                            seenBiblFull = true;
                            break;
                        }
                        if (TEIHeaderInfo.isTitleStmt(currentElement)) {
                            if (inBiblFull <= 0) break;
                            ++inTitleStmt;
                            break;
                        }
                        if (TEIHeaderInfo.isTitle(currentElement)) {
                            if (inTitleStmt <= 0) break;
                            this.title = "";
                            ++inTitle;
                            break;
                        }
                        if (!TEIHeaderInfo.isAuthor(currentElement) || inTitleStmt <= 0) break;
                        this.authorMap = new TreeMap<String, String>();
                        this.authorMap.put("name", "");
                        ++inAuthor;
                        break;
                    }
                    case 2: {
                        String localName = parser.getLocalName();
                        if (TEIHeaderInfo.isBiblFull(localName)) {
                            --inBiblFull;
                        }
                        if (TEIHeaderInfo.isTitleStmt(localName) && inBiblFull > 0) {
                            --inTitleStmt;
                        }
                        if (inBiblFull <= 0) {
                            done = seenBiblFull;
                        } else if (TEIHeaderInfo.isAuthor(localName)) {
                            --inAuthor;
                            if (this.authorMap != null) {
                                this.authorList.add(new TEIHeaderAuthor(this.authorMap));
                            }
                            this.authorMap = null;
                        } else if (TEIHeaderInfo.isTitle(localName)) {
                            --inTitle;
                        }
                        currentElement = "";
                        break;
                    }
                    case 4: 
                    case 12: {
                        if (inBiblFull <= 0 || currentElement.length() <= 0) break;
                        if (inAuthor > 0) {
                            this.authorMap.put("name", this.authorMap.get("name") + parser.getText());
                            break;
                        }
                        if (inTitle <= 0) break;
                        this.title = this.title + parser.getText();
                    }
                }
                event = parser.next();
            }
            parser.close();
        }
        catch (IOException e) {
            System.err.println(e);
        }
        catch (Exception e) {
            System.err.println(e);
        }
    }

    protected static boolean isBiblFull(String name) {
        return name.equals("fileDesc");
    }

    protected static boolean isTitleStmt(String name) {
        return name.equals("titleStmt");
    }

    protected static boolean isTitle(String name) {
        return name.equals("title");
    }

    protected static boolean isAuthor(String name) {
        return name.equals("author");
    }

    protected String safeString(String s) {
        return s == null ? "" : s;
    }
}

