/*
 * Decompiled with CFR 0.152.
 */
package edu.northwestern.at.morphadorner.tei;

import edu.northwestern.at.morphadorner.tei.TEIHeaderAuthor;
import edu.northwestern.at.utils.MapFactory;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class BibadornedInfo {
    protected String fileName;
    protected String title;
    protected String name;
    protected String circulationYear;
    protected String genre;
    protected String subgenre;
    protected String availability;
    protected boolean inMonkHeader;
    protected boolean monkHeaderFound = false;
    protected List<TEIHeaderAuthor> authorList = new ArrayList<TEIHeaderAuthor>();
    protected Map<String, String> authorMap = null;

    public BibadornedInfo(String bibadornedXMLFile) {
        this.parseXML(bibadornedXMLFile);
    }

    public String getFileName() {
        return this.fileName;
    }

    public String getTitle() {
        return this.title;
    }

    public List<TEIHeaderAuthor> getAuthors() {
        return this.authorList;
    }

    public String getGenre() {
        return this.genre;
    }

    public String getSubgenre() {
        return this.subgenre;
    }

    public String getCirculationYear() {
        return this.circulationYear;
    }

    public String getAvailability() {
        return this.availability;
    }

    public boolean getMonkHeaderFound() {
        return this.monkHeaderFound;
    }

    public void parseXML(String xmlFile) {
        DefaultHandler handler = new DefaultHandler(){
            boolean inAuthor = false;
            boolean isName = false;
            boolean isFileName = false;
            boolean isTitle = false;
            boolean isGenre = false;
            boolean isSubgenre = false;
            boolean isCircYear = false;
            boolean inMonkHeader = false;

            @Override
            public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
                if (qName.equals("text")) {
                    throw new SAXException("monkHeader not found");
                }
                if (qName.equals("monkHeader")) {
                    this.inMonkHeader = true;
                    BibadornedInfo.this.monkHeaderFound = true;
                }
                if (this.inMonkHeader) {
                    this.isFileName = qName.equals("fileName");
                    this.isTitle = qName.equals("title");
                    this.isGenre = qName.equals("genre");
                    this.isSubgenre = qName.equals("subgenre");
                    this.isCircYear = qName.equals("circulationYear");
                    if (qName.equals("author")) {
                        this.inAuthor = true;
                    }
                    if (this.inAuthor) {
                        this.isName = qName.equals("name");
                    }
                }
            }

            @Override
            public void endElement(String uri, String localName, String qName) throws SAXException {
                if (qName.equals("monkHeader")) {
                    this.inMonkHeader = false;
                    throw new SAXException("monkHeader done");
                }
                if (qName.equals("author")) {
                    this.inAuthor = false;
                }
            }

            @Override
            public void characters(char[] ch, int start, int length) throws SAXException {
                if (this.isName) {
                    BibadornedInfo.this.name = new String(ch, start, length);
                    this.isName = false;
                    Map<String, String> nameMap = MapFactory.createNewMap();
                    nameMap.put("name", BibadornedInfo.this.name);
                    BibadornedInfo.this.authorList.add(new TEIHeaderAuthor(nameMap));
                }
                if (this.isFileName) {
                    BibadornedInfo.this.fileName = new String(ch, start, length);
                    this.isFileName = false;
                }
                if (this.isTitle) {
                    BibadornedInfo.this.title = new String(ch, start, length);
                    this.isTitle = false;
                }
                if (this.isCircYear) {
                    BibadornedInfo.this.circulationYear = new String(ch, start, length);
                    this.isCircYear = false;
                }
                if (this.isGenre) {
                    BibadornedInfo.this.genre = new String(ch, start, length);
                    this.isGenre = false;
                }
                if (this.isSubgenre) {
                    BibadornedInfo.this.subgenre = new String(ch, start, length);
                    this.isSubgenre = false;
                }
            }
        };
        try {
            SAXParserFactory factory = SAXParserFactory.newInstance();
            SAXParser saxParser = factory.newSAXParser();
            this.monkHeaderFound = false;
            saxParser.parse(xmlFile, handler);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

