/*
 * Decompiled with CFR 0.152.
 */
package edu.northwestern.at.morphadorner.gate;

import edu.northwestern.at.morphadorner.corpuslinguistics.lexicon.DefaultSuffixLexicon;
import edu.northwestern.at.morphadorner.corpuslinguistics.lexicon.DefaultWordLexicon;
import edu.northwestern.at.morphadorner.corpuslinguistics.lexicon.Lexicon;
import edu.northwestern.at.morphadorner.corpuslinguistics.postagger.guesser.DefaultPartOfSpeechGuesser;
import edu.northwestern.at.morphadorner.corpuslinguistics.postagger.guesser.PartOfSpeechGuesser;
import edu.northwestern.at.morphadorner.corpuslinguistics.tokenizer.PennTreebankTokenizer;
import edu.northwestern.at.morphadorner.corpuslinguistics.tokenizer.WordTokenizer;
import gate.Annotation;
import gate.AnnotationSet;
import gate.Factory;
import gate.FeatureMap;
import gate.Resource;
import gate.creole.AbstractLanguageAnalyser;
import gate.creole.ExecutionException;
import gate.creole.ResourceInstantiationException;
import gate.util.GateRuntimeException;
import java.util.ArrayList;

public abstract class MorphAdornerGateWrapperBase
extends AbstractLanguageAnalyser {
    public static final String TAG_DOCUMENT_PARAMETER_NAME = "document";
    public static final String TAG_INPUT_AS_PARAMETER_NAME = "inputASName";
    public static final String TAG_OUTPUT_AS_PARAMETER_NAME = "outputASName";
    public static final String BASE_TOKEN_ANNOTATION_TYPE_PARAMETER_NAME = "baseTokenAnnotationType";
    public static final String BASE_SENTENCE_ANNOTATION_TYPE_PARAMETER_NAME = "baseSentenceAnnotationType";
    public static final String TOKEN_LEMMA_FEATURE_NAME = "lemma";
    public static final String TOKEN_SPELLING_FEATURE_NAME = "spelling";
    public static final String TOKEN_STANDARD_SPELLING_FEATURE_NAME = "standard";
    protected String inputASName;
    protected String outputASName;
    protected String outputAnnotationType;
    protected String baseTokenAnnotationType;
    protected String baseSentenceAnnotationType;
    protected String encoding;
    protected Lexicon wordLexicon;
    protected Lexicon suffixLexicon;
    protected PartOfSpeechGuesser guesser;
    protected WordTokenizer spellingTokenizer = new PennTreebankTokenizer();
    protected String spellingsURL = "data/standardspellings.txt";
    protected String alternateSpellingsURL = "data/ncfmergedspellingpairs.tab";
    protected static String tagSeparator = "|";
    protected static String lemmaSeparator = "|";

    public Resource init() throws ResourceInstantiationException {
        return super.init();
    }

    public void checkGateResources() throws ResourceInstantiationException {
        if (this.baseTokenAnnotationType == null || this.baseTokenAnnotationType.trim().length() == 0) {
            throw new ResourceInstantiationException("No base Token Annotation Type provided!");
        }
        if (this.baseSentenceAnnotationType == null || this.baseSentenceAnnotationType.trim().length() == 0) {
            throw new ResourceInstantiationException("No base Sentence Annotation Type provided!");
        }
    }

    public void execute() throws ExecutionException {
        super.execute();
    }

    protected void getLexicons() throws ResourceInstantiationException {
        try {
            this.wordLexicon = new DefaultWordLexicon();
            this.suffixLexicon = new DefaultSuffixLexicon();
        }
        catch (Exception e) {
            throw new ResourceInstantiationException(e.getMessage());
        }
    }

    protected void getPartOfSpeechGuesser() throws ResourceInstantiationException {
        this.guesser = new DefaultPartOfSpeechGuesser();
        this.guesser.setWordLexicon(this.wordLexicon);
        this.guesser.setSuffixLexicon(this.suffixLexicon);
    }

    protected void commonInit() throws ResourceInstantiationException {
        this.checkGateResources();
        this.getLexicons();
        this.getPartOfSpeechGuesser();
    }

    public void setInputASName(String newInputASName) {
        this.inputASName = newInputASName;
    }

    public String getInputASName() {
        return this.inputASName;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public String getBaseTokenAnnotationType() {
        return this.baseTokenAnnotationType;
    }

    public String getBaseSentenceAnnotationType() {
        return this.baseSentenceAnnotationType;
    }

    public String getOutputAnnotationType() {
        return this.outputAnnotationType;
    }

    public void setBaseTokenAnnotationType(String baseTokenAnnotationType) {
        this.baseTokenAnnotationType = baseTokenAnnotationType;
    }

    public void setBaseSentenceAnnotationType(String baseSentenceAnnotationtype) {
        this.baseSentenceAnnotationType = baseSentenceAnnotationtype;
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    public void setOutputAnnotationType(String outputAnnotationType) {
        this.outputAnnotationType = outputAnnotationType;
    }

    public String getOutputASName() {
        return this.outputASName;
    }

    public void setOutputASName(String outputASName) {
        this.outputASName = outputASName;
    }

    protected void addFeatures(Annotation annot, String featureName, String featureValue) throws GateRuntimeException {
        String tempOASN;
        String tempIASN = this.inputASName == null ? "" : this.inputASName;
        String string = tempOASN = this.outputASName == null ? "" : this.outputASName;
        if (this.outputAnnotationType.equals(this.baseTokenAnnotationType) && tempIASN.equals(tempOASN)) {
            annot.getFeatures().put((Object)featureName, (Object)featureValue);
            return;
        }
        int start = annot.getStartNode().getOffset().intValue();
        int end = annot.getEndNode().getOffset().intValue();
        AnnotationSet outputAS = this.outputASName == null ? this.document.getAnnotations() : this.document.getAnnotations(this.outputASName);
        AnnotationSet annotations = outputAS.get(this.outputAnnotationType);
        if (annotations == null || annotations.size() == 0) {
            FeatureMap features = Factory.newFeatureMap();
            features.put((Object)featureName, (Object)featureValue);
            try {
                outputAS.add(new Long(start), new Long(end), this.outputAnnotationType, features);
            }
            catch (Exception e) {
                throw new GateRuntimeException("Invalid Offsets");
            }
        }
        ArrayList tempList = new ArrayList(annotations.get());
        boolean found = false;
        for (int i = 0; i < tempList.size(); ++i) {
            Annotation annotation = (Annotation)tempList.get(i);
            int nodeStart = annotation.getStartNode().getOffset().intValue();
            int nodeEnd = annotation.getEndNode().getOffset().intValue();
            if (nodeStart != start || nodeEnd != end) continue;
            annotation.getFeatures().put((Object)featureName, (Object)featureValue);
            found = true;
            break;
        }
        if (!found) {
            FeatureMap features = Factory.newFeatureMap();
            features.put((Object)featureName, (Object)featureValue);
            try {
                outputAS.add(new Long(start), new Long(end), this.outputAnnotationType, features);
            }
            catch (Exception e) {
                throw new GateRuntimeException("Invalid Offsets");
            }
        }
    }
}

