/*
 * Decompiled with CFR 0.152.
 */
package edu.northwestern.at.morphadorner.corpuslinguistics.wordcounts;

import edu.northwestern.at.morphadorner.corpuslinguistics.stopwords.StopWords;
import edu.northwestern.at.morphadorner.corpuslinguistics.wordcounts.WordCountAndSentences;
import edu.northwestern.at.utils.CharUtils;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

public class WordCountUtils {
    public static <W extends Comparable> Map<String, WordCountAndSentences> countWordsInSentences(List<List<W>> sentences, StopWords stopWords) {
        TreeMap<String, WordCountAndSentences> wordCounts = new TreeMap<String, WordCountAndSentences>();
        boolean checkStopWords = stopWords != null;
        for (int i = 0; i < sentences.size(); ++i) {
            List<W> sentence = sentences.get(i);
            for (int j = 0; j < sentence.size(); ++j) {
                Comparable word = (Comparable)sentence.get(j);
                String lcWord = word.toString().toLowerCase();
                if (CharUtils.isPunctuationOrSymbol(lcWord) || checkStopWords && stopWords.isStopWord(lcWord)) continue;
                WordCountAndSentences wcs = (WordCountAndSentences)wordCounts.get(lcWord);
                if (wcs == null) {
                    wcs = new WordCountAndSentences((Comparable)((Object)lcWord));
                    wordCounts.put(lcWord, wcs);
                }
                ++wcs.count;
                wcs.sentences.add(i);
            }
        }
        return wordCounts;
    }

    protected WordCountUtils() {
    }
}

