/*
 * Decompiled with CFR 0.152.
 */
package edu.northwestern.at.morphadorner.corpuslinguistics.wordcounts;

import edu.northwestern.at.utils.Compare;
import java.util.Set;
import java.util.TreeSet;

public class WordCountAndSentences
implements Comparable {
    public Comparable word;
    public int count;
    public Set<Integer> sentences;

    public WordCountAndSentences() {
        this.word = null;
        this.count = 0;
        this.sentences = new TreeSet<Integer>();
    }

    public WordCountAndSentences(Comparable word) {
        this.word = word;
        this.count = 0;
        this.sentences = new TreeSet<Integer>();
    }

    public int compareTo(Object other) {
        int result = 0;
        if (other == null || !(other instanceof WordCountAndSentences)) {
            result = Integer.MIN_VALUE;
        } else {
            WordCountAndSentences otherCa = (WordCountAndSentences)other;
            result = -Compare.compare(this.count, otherCa.count);
            if (result == 0) {
                result = Compare.compare(this.sentences.size(), otherCa.sentences.size());
            }
            if (result == 0 && this.word != null && otherCa.word != null) {
                result = Compare.compare(this.word, otherCa.word);
            }
        }
        return result;
    }

    public String toString() {
        String result = this.word == null ? "(null) (0) in []" : this.word.toString() + " (" + this.count + ") in " + this.sentences;
        return result;
    }
}

