/*
 * Decompiled with CFR 0.152.
 */
package edu.northwestern.at.morphadorner.corpuslinguistics.tokenizer;

import edu.northwestern.at.morphadorner.corpuslinguistics.tokenizer.DefaultWordTokenizer;
import edu.northwestern.at.morphadorner.corpuslinguistics.tokenizer.WordTokenizer;
import edu.northwestern.at.utils.ClassUtils;
import edu.northwestern.at.utils.UTF8Properties;

public class WordTokenizerFactory {
    public static WordTokenizer newWordTokenizer() {
        String className = System.getProperty("wordtokenizer.class");
        if (className == null) {
            className = "DefaultWordTokenizer";
        }
        return WordTokenizerFactory.newWordTokenizer(className);
    }

    public static WordTokenizer newWordTokenizer(UTF8Properties properties) {
        String className = null;
        if (properties != null) {
            className = properties.getProperty("wordtokenizer.class");
        }
        if (className == null) {
            className = "DefaultWordTokenizer";
        }
        return WordTokenizerFactory.newWordTokenizer(className);
    }

    public static WordTokenizer newWordTokenizer(String className) {
        WordTokenizer wordTokenizer = null;
        try {
            wordTokenizer = (WordTokenizer)Class.forName(className).newInstance();
        }
        catch (Exception e) {
            String fixedClassName = ClassUtils.packageName(WordTokenizerFactory.class.getName()) + "." + className;
            try {
                wordTokenizer = (WordTokenizer)Class.forName(fixedClassName).newInstance();
            }
            catch (Exception e2) {
                System.err.println("Unable to create word tokenizer of class " + fixedClassName + ", using default.");
                wordTokenizer = new DefaultWordTokenizer();
            }
        }
        return wordTokenizer;
    }
}

