/*
 * Decompiled with CFR 0.152.
 */
package edu.northwestern.at.morphadorner.corpuslinguistics.tokenizer;

import edu.northwestern.at.morphadorner.corpuslinguistics.tokenizer.DefaultPostTokenizer;
import edu.northwestern.at.morphadorner.corpuslinguistics.tokenizer.PostTokenizer;
import edu.northwestern.at.utils.ClassUtils;
import edu.northwestern.at.utils.UTF8Properties;

public class PostTokenizerFactory {
    public static PostTokenizer newPostTokenizer() {
        String className = System.getProperty("posttokenizer.class");
        if (className == null) {
            className = "DefaultPostTokenizer";
        }
        return PostTokenizerFactory.newPostTokenizer(className);
    }

    public static PostTokenizer newPostTokenizer(UTF8Properties properties) {
        String className = null;
        if (properties != null) {
            className = properties.getProperty("posttokenizer.class");
        }
        if (className == null) {
            className = "DefaultPostTokenizer";
        }
        return PostTokenizerFactory.newPostTokenizer(className);
    }

    public static PostTokenizer newPostTokenizer(String className) {
        PostTokenizer postTokenizer = null;
        try {
            postTokenizer = (PostTokenizer)Class.forName(className).newInstance();
        }
        catch (Exception e) {
            String fixedClassName = ClassUtils.packageName(PostTokenizerFactory.class.getName()) + "." + className;
            try {
                postTokenizer = (PostTokenizer)Class.forName(fixedClassName).newInstance();
            }
            catch (Exception e2) {
                System.err.println("Unable to create posttokenizer of class " + fixedClassName + ", using default.");
                postTokenizer = new DefaultPostTokenizer();
            }
        }
        return postTokenizer;
    }
}

