/*
 * Decompiled with CFR 0.152.
 */
package edu.northwestern.at.morphadorner.corpuslinguistics.textsegmenter.texttiling;

import edu.northwestern.at.morphadorner.corpuslinguistics.stemmer.PorterStemmer;
import edu.northwestern.at.morphadorner.corpuslinguistics.stopwords.BaseStopWords;
import edu.northwestern.at.morphadorner.corpuslinguistics.stopwords.StopWords;
import edu.northwestern.at.morphadorner.corpuslinguistics.textsegmenter.struct.RawText;
import edu.northwestern.at.utils.ListFactory;
import edu.northwestern.at.utils.MapFactory;
import java.io.PrintStream;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class TextTiling {
    protected static PrintStream printStream;
    protected int w = 100;
    protected int s = 10;
    protected RawText C = new RawText();
    protected StopWords S = new BaseStopWords();
    protected Map<String, String> stemOf = MapFactory.createNewMap();
    protected double[] sim_score = new double[0];
    protected int[] site_loc = new int[0];
    protected double[] depth_score = new double[0];
    protected List<Integer> segmentation = ListFactory.createNewList();

    public TextTiling() {
    }

    public TextTiling(RawText c, StopWords s) {
        this.C = c;
        this.S = s;
        this.preprocess();
    }

    public List<Integer> getSegmentation() {
        return this.segmentation;
    }

    public Map<String, String> getStemOf() {
        return this.stemOf;
    }

    public StopWords getStopWords() {
        return this.S;
    }

    protected void blockAdd(String term, Map<String, Integer> B) {
        Integer freq = B.get(term);
        freq = freq == null ? new Integer(1) : new Integer(freq + 1);
        B.put(term, freq);
    }

    public void setWindowSize(int windowSize) {
        this.w = windowSize;
    }

    public void setStepSize(int stepSize) {
        this.s = stepSize;
    }

    protected double blockCosine(Map<String, Integer> B1, Map<String, Integer> B2) {
        int sq_b1 = 0;
        int sq_b2 = 0;
        int sum_b = 0;
        for (int W : B1.values()) {
            sq_b1 += W * W;
        }
        for (int W : B2.values()) {
            sq_b2 += W * W;
        }
        Map<String, Boolean> union = MapFactory.createNewMap(B1.size() + B2.size());
        Iterator<String> e = B1.keySet().iterator();
        while (e.hasNext()) {
            union.put(e.next(), true);
        }
        e = B2.keySet().iterator();
        while (e.hasNext()) {
            union.put(e.next(), true);
        }
        for (String term : union.keySet()) {
            Integer W1 = B1.get(term);
            Integer W2 = B2.get(term);
            if (W1 == null || W2 == null) continue;
            sum_b += W1 * W2;
        }
        return (double)sum_b / Math.sqrt(sq_b1 * sq_b2);
    }

    protected void blockRemove(String term, Map<String, Integer> B) {
        Integer freq = B.get(term);
        if (freq != null) {
            if (freq == 1) {
                B.remove(term);
            } else {
                B.put(term, freq - 1);
            }
        }
    }

    public void boundaryIdentification() {
        double mean = 0.0;
        double sd = 0.0;
        int neighbours = 3;
        int i = this.depth_score.length;
        while (i-- > 0) {
            mean += this.depth_score[i];
        }
        mean /= (double)this.depth_score.length;
        i = this.depth_score.length;
        while (i-- > 0) {
            sd += Math.pow(this.depth_score[i] - mean, 2.0);
        }
        double threshold = mean - (sd /= (double)this.depth_score.length) / 2.0;
        List<Integer> pseudo_boundaries = ListFactory.createNewList();
        boolean largest = true;
        int i2 = this.depth_score.length;
        while (i2-- > 0) {
            int j;
            if (!(this.depth_score[i2] >= threshold)) continue;
            largest = true;
            for (j = neighbours; largest && j > 0 && i2 - j > 0; --j) {
                if (!(this.depth_score[i2 - j] > this.depth_score[i2])) continue;
                largest = false;
            }
            for (j = neighbours; largest && j > 0 && i2 + j < this.depth_score.length; --j) {
                if (!(this.depth_score[i2 + j] > this.depth_score[i2])) continue;
                largest = false;
            }
            if (!largest) continue;
            pseudo_boundaries.add(this.site_loc[i2]);
        }
        int[] true_boundaries = new int[this.C.boundaries.size()];
        int i3 = true_boundaries.length;
        while (i3-- > 0) {
            true_boundaries[i3] = this.C.boundaries.get(i3);
        }
        int i4 = pseudo_boundaries.size();
        while (i4-- > 0) {
            int pseudo_boundary = (Integer)pseudo_boundaries.get(i4);
            int smallest_distance = Integer.MAX_VALUE;
            int closest_boundary = true_boundaries[0];
            int j = true_boundaries.length;
            while (j-- > 0) {
                int distance = Math.abs(true_boundaries[j] - pseudo_boundary);
                if (distance > smallest_distance) continue;
                smallest_distance = distance;
                closest_boundary = true_boundaries[j];
            }
            this.segmentation.add(closest_boundary);
        }
    }

    public void depthScore() {
        double maxima = 0.0;
        double dleft = 0.0;
        double dright = 0.0;
        this.depth_score = new double[this.sim_score.length];
        int i = this.sim_score.length;
        while (i-- > 0) {
            int j;
            maxima = this.sim_score[i];
            for (j = i; j > 0 && this.sim_score[j] >= maxima; --j) {
                maxima = this.sim_score[j];
            }
            dleft = maxima - this.sim_score[i];
            maxima = this.sim_score[i];
            for (j = i; j < this.sim_score.length && this.sim_score[j] >= maxima; ++j) {
                maxima = this.sim_score[j];
            }
            dright = maxima - this.sim_score[i];
            this.depth_score[i] = dleft + dright;
        }
    }

    protected boolean include(int i) {
        String token = this.C.text.get(i);
        return !this.S.isStopWord(token.toLowerCase());
    }

    protected void preprocess() {
        List<String> text = this.C.text;
        PorterStemmer stemmer = new PorterStemmer();
        int i = text.size();
        while (i-- > 0) {
            String token = text.get(i);
            this.stemOf.put(token, "");
        }
        for (String token : this.stemOf.keySet()) {
            this.stemOf.put(token, stemmer.stem(token));
        }
    }

    public void similarityDetermination() {
        int i;
        List<String> text = this.C.text;
        Map<String, Integer> left = MapFactory.createNewMap();
        Map<String, Integer> right = MapFactory.createNewMap();
        List<Float> score = ListFactory.createNewList();
        List<Integer> site = ListFactory.createNewList();
        int i2 = this.w;
        while (i2-- > 0) {
            this.blockAdd(this.stemOf.get(text.get(i2)), left);
        }
        i2 = this.w * 2;
        while (i2-- > this.w) {
            this.blockAdd(this.stemOf.get(text.get(i2)), right);
        }
        int end = text.size() - this.w;
        int step = 0;
        for (i = this.w; i < end; ++i) {
            if (step == 0) {
                score.add(new Float(this.blockCosine(left, right)));
                site.add(i);
                step = this.s;
            }
            if (this.include(i - this.w)) {
                this.blockRemove(this.stemOf.get(text.get(i - this.w)), left);
            }
            if (this.include(i)) {
                String token = text.get(i);
                this.blockAdd(this.stemOf.get(token), left);
                this.blockRemove(this.stemOf.get(token), right);
            }
            if (this.include(i + this.w)) {
                this.blockAdd(this.stemOf.get(text.get(i + this.w)), right);
            }
            --step;
        }
        if (step == 0) {
            score.add(new Float(this.blockCosine(left, right)));
            site.add(i);
            step = this.s;
        }
        this.sim_score = new double[score.size() - 2];
        this.site_loc = new int[site.size() - 2];
        for (int j = 0; j < this.sim_score.length; ++j) {
            this.sim_score[j] = (((Float)score.get(j)).doubleValue() + ((Float)score.get(j + 1)).doubleValue() + ((Float)score.get(j + 2)).doubleValue()) / 3.0;
            this.site_loc[j] = (Integer)site.get(j + 1);
        }
    }
}

