/*
 * Decompiled with CFR 0.152.
 */
package edu.northwestern.at.morphadorner.corpuslinguistics.textsegmenter.struct;

import edu.northwestern.at.morphadorner.corpuslinguistics.textsegmenter.struct.ContextVector;
import edu.northwestern.at.utils.MapFactory;
import java.util.Map;

public class EntropyVector {
    protected Map<String, TableValue> table = MapFactory.createNewMap();

    public EntropyVector(ContextVector v) {
        String[] keys = ContextVector.keys(v);
        int sum = ContextVector.sum(v);
        int i = keys.length;
        while (i-- > 0) {
            TableValue kv = new TableValue();
            kv.probability = (double)ContextVector.freq(keys[i], v) / (double)sum;
            kv.entropy = -Math.log(kv.probability);
            kv.inverse = 1.0 / (double)ContextVector.freq(keys[i], v);
            this.table.put(keys[i], kv);
        }
    }

    public static double entropy(String s, EntropyVector v) {
        double result = 0.0;
        TableValue kv = v.table.get(s);
        if (kv != null) {
            result = kv.entropy;
        }
        return result;
    }

    public static double inverse(String s, EntropyVector v) {
        double result = 0.0;
        TableValue kv = v.table.get(s);
        if (kv != null) {
            result = kv.inverse;
        }
        return result;
    }

    public static double probability(String s, EntropyVector v) {
        double result = 0.0;
        TableValue kv = v.table.get(s);
        if (kv != null) {
            result = kv.probability;
        }
        return result;
    }

    protected static class TableValue {
        public double probability;
        public double entropy;
        public double inverse;

        protected TableValue() {
        }
    }
}

