/*
 * Decompiled with CFR 0.152.
 */
package edu.northwestern.at.morphadorner.corpuslinguistics.textsegmenter.struct;

import edu.northwestern.at.morphadorner.corpuslinguistics.textsegmenter.struct.EntropyVector;
import edu.northwestern.at.utils.MapFactory;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class ContextVector
implements Externalizable {
    protected Map<String, Frequency> table = MapFactory.createNewMap();
    protected int sum = 0;

    public static double cos(ContextVector a, ContextVector b) {
        ContextVector vb;
        ContextVector va;
        if (a.table.size() < b.table.size()) {
            va = a;
            vb = b;
        } else {
            va = b;
            vb = a;
        }
        int dot = 0;
        int sfA = 0;
        int sfB = 0;
        for (String key : va.table.keySet()) {
            Frequency fA = va.table.get(key);
            Frequency fB = vb.table.get(key);
            sfA += fA.count * fA.count;
            if (fB == null) continue;
            dot += fA.count * fB.count;
        }
        for (Frequency fB : vb.table.values()) {
            sfB += fB.count * fB.count;
        }
        double magnitude = Math.sqrt(sfA * sfB);
        double result = 0.0;
        if (magnitude != 0.0) {
            result = (double)dot / magnitude;
        }
        return result;
    }

    public static double cos(ContextVector a, ContextVector b, EntropyVector tf) {
        double weight;
        Frequency fB;
        ContextVector vb;
        ContextVector va;
        if (a.table.size() < b.table.size()) {
            va = a;
            vb = b;
        } else {
            va = b;
            vb = a;
        }
        double dot = 0.0;
        double sfA = 0.0;
        double sfB = 0.0;
        for (String key : va.table.keySet()) {
            Frequency fA = va.table.get(key);
            fB = vb.table.get(key);
            weight = EntropyVector.inverse(key, tf);
            weight *= weight;
            sfA += (double)(fA.count * fA.count) * weight;
            if (fB == null) continue;
            dot += (double)(fA.count * fB.count) * weight;
        }
        for (String key : vb.table.keySet()) {
            fB = vb.table.get(key);
            weight = EntropyVector.inverse(key, tf);
            weight *= weight;
            sfB += (double)(fB.count * fB.count) * weight;
        }
        double magnitude = Math.sqrt(sfA * sfB);
        double result = 0.0;
        if (magnitude != 0.0) {
            result = dot / magnitude;
        }
        return result;
    }

    public static int dot(ContextVector a, ContextVector b) {
        ContextVector vb;
        ContextVector va;
        if (a.table.size() < b.table.size()) {
            va = a;
            vb = b;
        } else {
            va = b;
            vb = a;
        }
        int dot = 0;
        for (String key : va.table.keySet()) {
            Frequency fA = va.table.get(key);
            Frequency fB = vb.table.get(key);
            if (fB == null) continue;
            dot += fA.count * fB.count;
        }
        return dot;
    }

    public static int freq(String key, ContextVector vector) {
        int result = 0;
        Frequency f = vector.table.get(key);
        if (f != null) {
            result = f.count;
        }
        return result;
    }

    public static int inc(String key, int increment, ContextVector vector) {
        Frequency f = vector.table.get(key);
        if (f == null) {
            f = new Frequency();
            f.count = increment;
            vector.table.put(key, f);
        } else {
            f.count += increment;
        }
        vector.sum += increment;
        return f.count;
    }

    public static String[] keys(ContextVector v) {
        String[] result = new String[v.table.size()];
        Iterator<String> iterator = v.table.keySet().iterator();
        for (int i = 0; i < result.length; ++i) {
            result[i] = iterator.next();
        }
        return result;
    }

    @Override
    public final void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        HashMap tableObj;
        this.table = tableObj = (HashMap)in.readObject();
        this.sum = in.readInt();
    }

    public static int sum(ContextVector vector) {
        return vector.sum;
    }

    @Override
    public final void writeExternal(ObjectOutput out) throws IOException {
        out.writeObject(this.table);
        out.writeInt(this.sum);
    }

    protected static class Frequency
    implements Externalizable {
        public int count = 0;

        @Override
        public void writeExternal(ObjectOutput out) throws IOException {
            out.writeInt(this.count);
        }

        @Override
        public void readExternal(ObjectInput in) throws IOException {
            this.count = in.readInt();
        }
    }
}

