/*
 * Decompiled with CFR 0.152.
 */
package edu.northwestern.at.morphadorner.corpuslinguistics.textsegmenter;

import edu.northwestern.at.morphadorner.corpuslinguistics.textsegmenter.DefaultTextSegmenter;
import edu.northwestern.at.morphadorner.corpuslinguistics.textsegmenter.TextSegmenter;
import edu.northwestern.at.utils.ClassUtils;
import edu.northwestern.at.utils.UTF8Properties;

public class TextSegmenterFactory {
    public static TextSegmenter newTextSegmenter() {
        String className = System.getProperty("segmenter.class");
        if (className == null) {
            className = "DefaultTextSegmenter";
        }
        return TextSegmenterFactory.newTextSegmenter(className);
    }

    public static TextSegmenter newTextSegmenter(UTF8Properties properties) {
        String className = null;
        if (properties != null) {
            className = properties.getProperty("segmenter.class");
        }
        if (className == null) {
            className = "DefaultTextSegmenter";
        }
        return TextSegmenterFactory.newTextSegmenter(className);
    }

    public static TextSegmenter newTextSegmenter(String className) {
        TextSegmenter segmenter = null;
        try {
            segmenter = (TextSegmenter)Class.forName(className).newInstance();
        }
        catch (Exception e) {
            String fixedClassName = ClassUtils.packageName(TextSegmenterFactory.class.getName()) + "." + className;
            try {
                segmenter = (TextSegmenter)Class.forName(fixedClassName).newInstance();
            }
            catch (Exception e2) {
                System.err.println("Unable to create segmenter of class " + fixedClassName + ", using default.");
                try {
                    segmenter = new DefaultTextSegmenter();
                }
                catch (Exception e3) {
                    // empty catch block
                }
            }
        }
        return segmenter;
    }
}

