/*
 * Decompiled with CFR 0.152.
 */
package edu.northwestern.at.morphadorner.corpuslinguistics.syllablecounter;

import edu.northwestern.at.morphadorner.corpuslinguistics.syllablecounter.DefaultSyllableCounter;
import edu.northwestern.at.morphadorner.corpuslinguistics.syllablecounter.SyllableCounter;
import edu.northwestern.at.utils.ClassUtils;
import edu.northwestern.at.utils.UTF8Properties;

public class SyllableCounterFactory {
    public static SyllableCounter newSyllableCounter() {
        String className = System.getProperty("syllablecounter.class");
        if (className == null) {
            className = "DefaultSyllableCounter";
        }
        return SyllableCounterFactory.newSyllableCounter(className);
    }

    public static SyllableCounter newSyllableCounter(UTF8Properties properties) {
        String className = null;
        if (properties != null) {
            className = properties.getProperty("syllablecounter.class");
        }
        if (className == null) {
            className = "DefaultSyllableCounter";
        }
        return SyllableCounterFactory.newSyllableCounter(className);
    }

    public static SyllableCounter newSyllableCounter(String className) {
        SyllableCounter syllablecounter = null;
        try {
            syllablecounter = (SyllableCounter)Class.forName(className).newInstance();
        }
        catch (Exception e) {
            String fixedClassName = ClassUtils.packageName(SyllableCounterFactory.class.getName()) + "." + className;
            try {
                syllablecounter = (SyllableCounter)Class.forName(fixedClassName).newInstance();
            }
            catch (Exception e2) {
                System.err.println("Unable to create syllablecounter of class " + fixedClassName + ", using default.");
                try {
                    syllablecounter = new DefaultSyllableCounter();
                }
                catch (Exception e3) {
                    // empty catch block
                }
            }
        }
        return syllablecounter;
    }
}

