/*
 * Decompiled with CFR 0.152.
 */
package edu.northwestern.at.morphadorner.corpuslinguistics.syllablecounter;

import edu.northwestern.at.morphadorner.corpuslinguistics.syllablecounter.SyllableCounter;
import edu.northwestern.at.utils.MapFactory;
import edu.northwestern.at.utils.UnicodeReader;
import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URL;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class EnglishSyllableCounter
implements SyllableCounter {
    protected static String syllableCountFileName = "resources/englishsyllablecounts.tab";
    protected Map<String, Integer> syllableCountMap = MapFactory.createNewMap();
    protected static final Pattern[] SubtractSyllables = new Pattern[]{Pattern.compile("cial"), Pattern.compile("tia"), Pattern.compile("cius"), Pattern.compile("cious"), Pattern.compile("giu"), Pattern.compile("ion"), Pattern.compile("iou"), Pattern.compile("sia$"), Pattern.compile(".ely$")};
    protected static final Pattern[] AddSyllables = new Pattern[]{Pattern.compile("ia"), Pattern.compile("riet"), Pattern.compile("dien"), Pattern.compile("iu"), Pattern.compile("io"), Pattern.compile("ii"), Pattern.compile("[aeiouym]bl$"), Pattern.compile("[aeiou]{3}"), Pattern.compile("^mc"), Pattern.compile("ism$"), Pattern.compile("([^aeiouy])\u0001l$"), Pattern.compile("[^l]lien"), Pattern.compile("^coa[dglx]."), Pattern.compile("[^gq]ua[^auieo]"), Pattern.compile("dnt$")};

    public EnglishSyllableCounter() {
        try {
            this.syllableCountMap = this.loadSyllableCountMap(EnglishSyllableCounter.class.getResource(syllableCountFileName), "\t", "", "utf-8");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public Map<String, Integer> loadSyllableCountMap(URL mapURL, String separator, String qualifier, String encoding) throws IOException, FileNotFoundException {
        Map<String, Integer> map = MapFactory.createNewMap();
        if (mapURL != null) {
            BufferedReader bufferedReader = new BufferedReader(new UnicodeReader(mapURL.openStream(), encoding));
            String inputLine = bufferedReader.readLine();
            while (inputLine != null) {
                String[] tokens = inputLine.split(separator);
                if (tokens.length > 1) {
                    int count = Integer.parseInt(tokens[1]);
                    map.put(tokens[0], count);
                }
                inputLine = bufferedReader.readLine();
            }
            bufferedReader.close();
        }
        return map;
    }

    public Map<String, Integer> getSyllableCountMap() {
        return this.syllableCountMap;
    }

    @Override
    public int countSyllables(String word) {
        int result = 0;
        if (word == null || word.length() == 0) {
            return result;
        }
        String lcWord = word.toLowerCase();
        if (this.syllableCountMap.containsKey(lcWord)) {
            result = this.syllableCountMap.get(lcWord);
        } else {
            Matcher m;
            lcWord = lcWord.replaceAll("'", "").replaceAll("e$", "");
            String[] vowelGroups = lcWord.split("[^aeiouy]+");
            for (Pattern p : SubtractSyllables) {
                m = p.matcher(lcWord);
                if (!m.find()) continue;
                --result;
            }
            for (Pattern p : AddSyllables) {
                m = p.matcher(lcWord);
                if (!m.find()) continue;
                ++result;
            }
            if (lcWord.length() == 1) {
                ++result;
            }
            result = vowelGroups.length > 0 && vowelGroups[0].length() == 0 ? (result += vowelGroups.length - 1) : (result += vowelGroups.length);
        }
        return Math.max(result, 1);
    }
}

