/*
 * Decompiled with CFR 0.152.
 */
package edu.northwestern.at.morphadorner.corpuslinguistics.stringsimilarity;

import edu.northwestern.at.morphadorner.corpuslinguistics.stringsimilarity.StringSimilarity;
import edu.northwestern.at.utils.ListFactory;
import java.util.List;

public class LetterPairSimilarity
implements StringSimilarity {
    protected static String[] letterPairs(String s) {
        int numPairs = Math.max(s.length() - 1, 0);
        String[] pairs = new String[numPairs];
        if (numPairs > 0) {
            for (int i = 0; i < numPairs; ++i) {
                pairs[i] = s.substring(i, i + 2);
            }
        }
        return pairs;
    }

    protected static List<String> wordLetterPairs(String s) {
        List<String> allPairs = ListFactory.createNewList();
        String[] words = s.split("\\s");
        for (int w = 0; w < words.length; ++w) {
            String[] pairsInWord = LetterPairSimilarity.letterPairs(words[w]);
            for (int p = 0; p < pairsInWord.length; ++p) {
                allPairs.add(pairsInWord[p]);
            }
        }
        return allPairs;
    }

    public static double letterPairSimilarity(String s1, String s2) {
        List<String> pairs1 = LetterPairSimilarity.wordLetterPairs(s1.toUpperCase());
        List<String> pairs2 = LetterPairSimilarity.wordLetterPairs(s2.toUpperCase());
        int intersection = 0;
        int union = pairs1.size() + pairs2.size();
        block0: for (int i = 0; i < pairs1.size(); ++i) {
            String pair1 = pairs1.get(i);
            for (int j = 0; j < pairs2.size(); ++j) {
                String pair2 = pairs2.get(j);
                if (!pair1.equals(pair2)) continue;
                ++intersection;
                pairs2.remove(j);
                continue block0;
            }
        }
        double result = 0.0;
        if ((double)union >= 0.0) {
            result = 2.0 * (double)intersection / (double)union;
        }
        return result;
    }

    @Override
    public double similarity(String s1, String s2) {
        return LetterPairSimilarity.letterPairSimilarity(s1, s2);
    }
}

